/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.error.NotYetImplemented;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.field.DoubleFieldReader;
import org.apache.druid.frame.field.NumericArrayFieldReader;
import org.apache.druid.frame.field.NumericArrayFieldSelector;
import org.apache.druid.frame.field.ReadableFieldPointer;
import org.apache.druid.frame.field.SettableFieldPointer;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.RowSignature;

public class DoubleArrayFieldReader
extends NumericArrayFieldReader {
    private final FrameType frameType;

    public DoubleArrayFieldReader(FrameType frameType) {
        this.frameType = frameType;
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(Memory memory, ReadableFieldPointer fieldPointer) {
        return new NumericArrayFieldSelector<Double>(memory, fieldPointer){
            private static final int FIELD_SIZE = 9;
            final SettableFieldPointer fieldPointer;
            final ColumnValueSelector<?> columnValueSelector;
            {
                this.fieldPointer = new SettableFieldPointer();
                this.columnValueSelector = DoubleFieldReader.forArray(DoubleArrayFieldReader.this.frameType).makeColumnValueSelector(this.memory, this.fieldPointer);
            }

            @Override
            @Nullable
            public Double getIndividualValueAtMemory(long position) {
                this.fieldPointer.setPositionAndLength(position, 9L);
                if (this.columnValueSelector.isNull()) {
                    return null;
                }
                return this.columnValueSelector.getDouble();
            }

            @Override
            public int getIndividualFieldSize() {
                return 9;
            }
        };
    }

    @Override
    public Column makeRACColumn(Frame frame, RowSignature signature, String columnName) {
        throw NotYetImplemented.ex(null, "Class cannot create an RAC column.", new Object[0]);
    }
}

