/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.hook;

import com.google.errorprone.annotations.Immutable;
import java.util.Objects;
import org.apache.calcite.rel.RelNode;
import org.apache.druid.query.Query;

@FunctionalInterface
public interface DruidHook<T> {
    public static final HookKey<RelNode> CONVERTED_PLAN = new HookKey<RelNode>("converted", RelNode.class);
    public static final HookKey<RelNode> LOGICAL_PLAN = new HookKey<RelNode>("logicalPlan", RelNode.class);
    public static final HookKey<RelNode> DRUID_PLAN = new HookKey<RelNode>("druidPlan", RelNode.class);
    public static final HookKey<String> SQL = new HookKey<String>("sql", String.class);
    public static final HookKey<String> MSQ_PLAN = new HookKey<String>("msqPlan", String.class);
    public static final HookKey<Query> NATIVE_PLAN = new HookKey<Query>("nativePlan", Query.class);

    public void invoke(HookKey<T> var1, T var2);

    @Immutable
    public static class HookKey<T> {
        private final String label;
        private final Class<T> type;

        public HookKey(String label, Class<T> type) {
            this.label = label;
            this.type = type;
        }

        public int hashCode() {
            return Objects.hash(this.label, this.type);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HookKey other = (HookKey)obj;
            return Objects.equals(this.label, other.label) && Objects.equals(this.type, other.type);
        }
    }
}

