/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.run.EngineFeature;

public class PartialDruidQuery {
    private final Supplier<RelBuilder> builderSupplier;
    private final RelNode scan;
    private final Filter whereFilter;
    private final Project selectProject;
    private final Aggregate aggregate;
    private final Filter havingFilter;
    private final Project aggregateProject;
    private final Sort sort;
    private final Project sortProject;
    private final Window window;
    private final Project windowProject;

    private PartialDruidQuery(Supplier<RelBuilder> builderSupplier, RelNode scan, Filter whereFilter, Project selectProject, Aggregate aggregate, Project aggregateProject, Filter havingFilter, Sort sort, Project sortProject, Window window, Project windowProject) {
        this.builderSupplier = (Supplier)Preconditions.checkNotNull(builderSupplier, (Object)"builderSupplier");
        this.scan = (RelNode)Preconditions.checkNotNull((Object)scan, (Object)"scan");
        this.whereFilter = whereFilter;
        this.selectProject = selectProject;
        this.aggregate = aggregate;
        this.aggregateProject = aggregateProject;
        this.havingFilter = havingFilter;
        this.sort = sort;
        this.sortProject = sortProject;
        this.window = window;
        this.windowProject = windowProject;
    }

    public static PartialDruidQuery create(RelNode inputRel) {
        Supplier<RelBuilder> builderSupplier = () -> RelFactories.LOGICAL_BUILDER.create(inputRel.getCluster(), inputRel.getTable() != null ? inputRel.getTable().getRelOptSchema() : null);
        return new PartialDruidQuery(builderSupplier, inputRel, null, null, null, null, null, null, null, null, null);
    }

    public static PartialDruidQuery createOuterQuery(PartialDruidQuery inputQuery, PlannerContext plannerContext) {
        RelNode inputRel = inputQuery.leafRel();
        return PartialDruidQuery.create(inputRel.copy(inputQuery.getTraitSet(inputRel.getConvention(), plannerContext), inputRel.getInputs()));
    }

    public RelNode getScan() {
        return this.scan;
    }

    public Filter getWhereFilter() {
        return this.whereFilter;
    }

    public Project getSelectProject() {
        return this.selectProject;
    }

    public Aggregate getAggregate() {
        return this.aggregate;
    }

    public Filter getHavingFilter() {
        return this.havingFilter;
    }

    public Project getAggregateProject() {
        return this.aggregateProject;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Project getSortProject() {
        return this.sortProject;
    }

    public Window getWindow() {
        return this.window;
    }

    public Project getWindowProject() {
        return this.windowProject;
    }

    public PartialDruidQuery withWhereFilter(Filter newWhereFilter) {
        this.validateStage(Stage.WHERE_FILTER);
        return new PartialDruidQuery(this.builderSupplier, this.scan, newWhereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery withSelectProject(Project newSelectProject) {
        this.validateStage(Stage.SELECT_PROJECT);
        if (this.selectProject != null) {
            return this.mergeProject(newSelectProject);
        }
        Project theProject = newSelectProject;
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, theProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery mergeProject(Project newSelectProject) {
        Project theProject;
        if (this.stage() != Stage.SELECT_PROJECT) {
            throw new ISE("Expected partial query state to be [%s], but found [%s]", new Object[]{Stage.SELECT_PROJECT, this.stage()});
        }
        List newProjectRexNodes = RelOptUtil.pushPastProject((List)newSelectProject.getProjects(), (Project)this.selectProject);
        if (RexUtil.isIdentity((List)newProjectRexNodes, (RelDataType)this.selectProject.getInput().getRowType())) {
            theProject = null;
        } else {
            RelBuilder relBuilder = this.builderSupplier.get();
            relBuilder.push(this.selectProject.getInput());
            relBuilder.project((Iterable)newProjectRexNodes, (Iterable)newSelectProject.getRowType().getFieldNames(), true);
            theProject = (Project)relBuilder.build();
        }
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, theProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery withAggregate(Aggregate newAggregate) {
        this.validateStage(Stage.AGGREGATE);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, newAggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery withHavingFilter(Filter newHavingFilter) {
        this.validateStage(Stage.HAVING_FILTER);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, newHavingFilter, this.sort, this.sortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery withAggregateProject(Project newAggregateProject) {
        this.validateStage(Stage.AGGREGATE_PROJECT);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, newAggregateProject, this.havingFilter, this.sort, this.sortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery withSort(Sort newSort) {
        this.validateStage(Stage.SORT);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, newSort, this.sortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery withSortProject(Project newSortProject) {
        this.validateStage(Stage.SORT_PROJECT);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, newSortProject, this.window, this.windowProject);
    }

    public PartialDruidQuery withWindow(Window newWindow) {
        this.validateStage(Stage.WINDOW);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject, newWindow, this.windowProject);
    }

    public PartialDruidQuery withWindowProject(Project newWindowProject) {
        this.validateStage(Stage.WINDOW_PROJECT);
        return new PartialDruidQuery(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.aggregateProject, this.havingFilter, this.sort, this.sortProject, this.window, newWindowProject);
    }

    public RelDataType getRowType() {
        return this.leafRel().getRowType();
    }

    public RelTraitSet getTraitSet(Convention convention, PlannerContext plannerContext) {
        RelTraitSet leafRelTraits = this.leafRel().getTraitSet();
        Stage currentStage = this.stage();
        switch (currentStage.ordinal()) {
            case 3: 
            case 5: {
                RelCollation collation = (RelCollation)leafRelTraits.getTrait((RelTraitDef)RelCollationTraitDef.INSTANCE);
                if (!plannerContext.featureAvailable(EngineFeature.GROUPBY_IMPLICITLY_SORTS) || collation != null && !collation.getFieldCollations().isEmpty() || this.aggregate.getGroupSets().size() != 1) break;
                ArrayList<RelFieldCollation> sortFields = new ArrayList<RelFieldCollation>();
                if (currentStage == Stage.AGGREGATE) {
                    for (int i = 0; i < this.aggregate.getGroupCount(); ++i) {
                        sortFields.add(new RelFieldCollation(i));
                    }
                } else {
                    int mapping;
                    int i;
                    List projectExprs = this.aggregateProject.getProjects();
                    Int2IntOpenHashMap dimensionMapping = new Int2IntOpenHashMap();
                    dimensionMapping.defaultReturnValue(-1);
                    for (i = 0; i < projectExprs.size(); ++i) {
                        RexNode projectExpr = (RexNode)projectExprs.get(i);
                        if (!projectExpr.isA(SqlKind.INPUT_REF)) continue;
                        dimensionMapping.put(((RexInputRef)projectExpr).getIndex(), i);
                    }
                    for (i = 0; i < this.aggregate.getGroupCount() && (mapping = dimensionMapping.applyAsInt(i)) >= 0; ++i) {
                        sortFields.add(new RelFieldCollation(mapping));
                    }
                }
                return leafRelTraits.plus((RelTrait)convention).plus((RelTrait)RelCollations.of(sortFields));
            }
        }
        return leafRelTraits.plus((RelTrait)convention);
    }

    public DruidQuery build(DataSource dataSource, RowSignature sourceRowSignature, PlannerContext plannerContext, RexBuilder rexBuilder, boolean finalizeAggregations, boolean applyPolicies) {
        return DruidQuery.fromPartialQuery(this, dataSource, sourceRowSignature, plannerContext, rexBuilder, finalizeAggregations, applyPolicies, null);
    }

    public DruidQuery build(DataSource dataSource, RowSignature sourceRowSignature, PlannerContext plannerContext, RexBuilder rexBuilder, boolean finalizeAggregations, boolean applyPolicies, @Nullable VirtualColumnRegistry virtualColumnRegistry) {
        return DruidQuery.fromPartialQuery(this, dataSource, sourceRowSignature, plannerContext, rexBuilder, finalizeAggregations, applyPolicies, virtualColumnRegistry);
    }

    public boolean canAccept(Stage stage) {
        return stage.canFollow(this.stage());
    }

    public Stage stage() {
        if (this.windowProject != null) {
            return Stage.WINDOW_PROJECT;
        }
        if (this.window != null) {
            return Stage.WINDOW;
        }
        if (this.sortProject != null) {
            return Stage.SORT_PROJECT;
        }
        if (this.sort != null) {
            return Stage.SORT;
        }
        if (this.aggregateProject != null) {
            return Stage.AGGREGATE_PROJECT;
        }
        if (this.havingFilter != null) {
            return Stage.HAVING_FILTER;
        }
        if (this.aggregate != null) {
            return Stage.AGGREGATE;
        }
        if (this.selectProject != null) {
            return Stage.SELECT_PROJECT;
        }
        if (this.whereFilter != null) {
            return Stage.WHERE_FILTER;
        }
        return Stage.SCAN;
    }

    public RelNode leafRel() {
        Stage currentStage = this.stage();
        switch (currentStage.ordinal()) {
            case 9: {
                return this.windowProject;
            }
            case 8: {
                return this.window;
            }
            case 7: {
                return this.sortProject;
            }
            case 6: {
                return this.sort;
            }
            case 5: {
                return this.aggregateProject;
            }
            case 4: {
                return this.havingFilter;
            }
            case 3: {
                return this.aggregate;
            }
            case 2: {
                return this.selectProject;
            }
            case 1: {
                return this.whereFilter;
            }
            case 0: {
                return this.scan;
            }
        }
        throw new ISE("Unknown stage: %s", new Object[]{currentStage});
    }

    public double estimateCost() {
        double cost = 1.0;
        if (this.getSelectProject() != null) {
            for (RexNode rexNode : this.getSelectProject().getProjects()) {
                if (rexNode.isA(SqlKind.INPUT_REF)) continue;
                cost += 0.25;
            }
        }
        if (this.getWhereFilter() != null) {
            cost *= 0.1;
        }
        if (this.getAggregate() != null) {
            cost += 0.25 * (double)this.getAggregate().getGroupSet().size();
            cost += 0.05 * (double)this.getAggregate().getAggCallList().size();
        }
        if (this.getSort() != null) {
            if (!this.getSort().collation.getFieldCollations().isEmpty()) {
                cost *= 10.0;
            }
            if (this.getSort().fetch != null) {
                cost *= 0.5;
            }
        }
        if (this.getAggregateProject() != null) {
            for (RexNode rexNode : this.getAggregateProject().getProjects()) {
                if (rexNode.isA(SqlKind.INPUT_REF)) continue;
                cost += 0.25;
            }
        }
        if (this.getSortProject() != null) {
            for (RexNode rexNode : this.getSortProject().getProjects()) {
                if (rexNode.isA(SqlKind.INPUT_REF)) continue;
                cost += 0.25;
            }
        }
        return cost += 0.05 * (double)this.getRowType().getFieldCount();
    }

    private void validateStage(Stage stage) {
        if (!this.canAccept(stage)) {
            throw new ISE("Cannot move from stage[%s] to stage[%s]", new Object[]{this.stage(), stage});
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartialDruidQuery that = (PartialDruidQuery)o;
        return Objects.equals(this.scan, that.scan) && Objects.equals(this.whereFilter, that.whereFilter) && Objects.equals(this.selectProject, that.selectProject) && Objects.equals(this.aggregate, that.aggregate) && Objects.equals(this.havingFilter, that.havingFilter) && Objects.equals(this.aggregateProject, that.aggregateProject) && Objects.equals(this.sort, that.sort) && Objects.equals(this.sortProject, that.sortProject) && Objects.equals(this.window, that.window) && Objects.equals(this.windowProject, that.windowProject);
    }

    public int hashCode() {
        return Objects.hash(this.builderSupplier, this.scan, this.whereFilter, this.selectProject, this.aggregate, this.havingFilter, this.aggregateProject, this.sort, this.sortProject, this.window, this.windowProject);
    }

    public String toString() {
        return "PartialDruidQuery{scan=" + String.valueOf(this.scan) + ", whereFilter=" + String.valueOf(this.whereFilter) + ", selectProject=" + String.valueOf(this.selectProject) + ", aggregate=" + String.valueOf(this.aggregate) + ", havingFilter=" + String.valueOf(this.havingFilter) + ", aggregateProject=" + String.valueOf(this.aggregateProject) + ", sort=" + String.valueOf(this.sort) + ", sortProject=" + String.valueOf(this.sortProject) + ", window=" + String.valueOf(this.window) + ", windowProject=" + String.valueOf(this.windowProject) + "}";
    }

    public static enum Stage {
        SCAN,
        WHERE_FILTER,
        SELECT_PROJECT{

            @Override
            public boolean canFollow(Stage stage) {
                return stage.compareTo(this) <= 0;
            }
        }
        ,
        AGGREGATE,
        HAVING_FILTER{

            @Override
            public boolean canFollow(Stage stage) {
                return stage == AGGREGATE;
            }
        }
        ,
        AGGREGATE_PROJECT{

            @Override
            public boolean canFollow(Stage stage) {
                return stage == AGGREGATE || stage == HAVING_FILTER;
            }
        }
        ,
        SORT,
        SORT_PROJECT{

            @Override
            public boolean canFollow(Stage stage) {
                return stage == SORT;
            }
        }
        ,
        WINDOW{

            @Override
            public boolean canFollow(Stage stage) {
                return stage == SCAN;
            }
        }
        ,
        WINDOW_PROJECT{

            @Override
            public boolean canFollow(Stage stage) {
                return stage == WINDOW;
            }
        };


        public boolean canFollow(Stage stage) {
            return stage.compareTo(this) < 0;
        }
    }
}

