/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.catalog.model.ColumnSpec;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="hideColumns", value=HideColumns.class), @JsonSubTypes.Type(name="unhideColumns", value=UnhideColumns.class), @JsonSubTypes.Type(name="dropColumns", value=DropColumns.class), @JsonSubTypes.Type(name="updateProperties", value=UpdateProperties.class), @JsonSubTypes.Type(name="updateColumns", value=UpdateColumns.class), @JsonSubTypes.Type(name="moveColumn", value=MoveColumn.class)})
public class TableEditRequest {
    public static final String TYPE_PROPERTY = "type";

    public static class MoveColumn
    extends TableEditRequest {
        @JsonProperty
        public final String column;
        @JsonProperty
        public final Position where;
        @Nullable
        @JsonProperty
        public final String anchor;

        @JsonCreator
        public MoveColumn(@JsonProperty(value="column") String column, @JsonProperty(value="where") Position where, @JsonProperty(value="anchor") @Nullable String anchor) {
            this.column = column;
            this.where = where;
            this.anchor = anchor;
        }

        public static enum Position {
            FIRST,
            LAST,
            BEFORE,
            AFTER;

        }
    }

    public static class UpdateColumns
    extends TableEditRequest {
        @JsonProperty(value="columns")
        public final List<ColumnSpec> columns;

        @JsonCreator
        public UpdateColumns(@JsonProperty(value="columns") List<ColumnSpec> columns) {
            this.columns = columns;
        }
    }

    public static class UpdateProperties
    extends TableEditRequest {
        @JsonProperty(value="properties")
        public final Map<String, Object> properties;

        @JsonCreator
        public UpdateProperties(@JsonProperty(value="properties") Map<String, Object> properties) {
            this.properties = properties;
        }
    }

    public static class DropColumns
    extends TableEditRequest {
        @JsonProperty(value="columns")
        public final List<String> columns;

        @JsonCreator
        public DropColumns(@JsonProperty(value="columns") List<String> columns) {
            this.columns = columns;
        }
    }

    public static class UnhideColumns
    extends TableEditRequest {
        @JsonProperty(value="columns")
        public final List<String> columns;

        @JsonCreator
        public UnhideColumns(@JsonProperty(value="columns") List<String> columns) {
            this.columns = columns;
        }
    }

    public static class HideColumns
    extends TableEditRequest {
        @JsonProperty(value="columns")
        public final List<String> columns;

        @JsonCreator
        public HideColumns(@JsonProperty(value="columns") List<String> columns) {
            this.columns = columns;
        }
    }
}

