/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.worker;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.TaskResource;

public class TaskAnnouncement {
    public static final String TASK_ID_KEY = "id";
    private final String taskType;
    private final TaskStatus taskStatus;
    private final TaskResource taskResource;
    private final TaskLocation taskLocation;
    @Nullable
    private final String taskDataSource;

    public static TaskAnnouncement create(Task task, TaskStatus status, TaskLocation location) {
        return TaskAnnouncement.create(task.getId(), task.getType(), task.getTaskResource(), status, location, task.getDataSource());
    }

    public static TaskAnnouncement create(String taskId, String taskType, TaskResource resource, TaskStatus status, TaskLocation location, String taskDataSource) {
        Preconditions.checkArgument((boolean)status.getId().equals(taskId), (Object)"task id == status id");
        return new TaskAnnouncement(null, taskType, null, status, resource, location, taskDataSource);
    }

    @JsonCreator
    private TaskAnnouncement(@JsonProperty(value="id") String taskId, @JsonProperty(value="type") String taskType, @JsonProperty(value="status") TaskState status, @JsonProperty(value="taskStatus") TaskStatus taskStatus, @JsonProperty(value="taskResource") TaskResource taskResource, @JsonProperty(value="taskLocation") TaskLocation taskLocation, @JsonProperty(value="taskDataSource") String taskDataSource) {
        this.taskType = taskType;
        this.taskStatus = taskStatus != null ? taskStatus : TaskStatus.fromCode((String)taskId, (TaskState)status);
        this.taskResource = taskResource == null ? new TaskResource(this.taskStatus.getId(), 1) : taskResource;
        this.taskLocation = taskLocation == null ? TaskLocation.unknown() : taskLocation;
        this.taskDataSource = taskDataSource;
    }

    @JsonProperty(value="id")
    public String getTaskId() {
        return this.taskStatus.getId();
    }

    @JsonProperty(value="type")
    public String getTaskType() {
        return this.taskType;
    }

    @JsonProperty(value="status")
    public TaskState getStatus() {
        return this.taskStatus.getStatusCode();
    }

    @JsonProperty(value="taskStatus")
    public TaskStatus getTaskStatus() {
        return this.taskStatus;
    }

    @JsonProperty(value="taskResource")
    public TaskResource getTaskResource() {
        return this.taskResource;
    }

    @JsonProperty(value="taskLocation")
    public TaskLocation getTaskLocation() {
        return this.taskLocation;
    }

    @JsonProperty(value="taskDataSource")
    public String getTaskDataSource() {
        return this.taskDataSource;
    }

    public String toString() {
        return "TaskAnnouncement{taskType=" + this.taskType + ", taskStatus=" + String.valueOf(this.taskStatus) + ", taskResource=" + String.valueOf(this.taskResource) + ", taskLocation=" + String.valueOf(this.taskLocation) + ", taskDataSource=" + this.taskDataSource + "}";
    }
}

