/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.druid.rpc.ServiceLocation;

public class BrokerSyncStatus {
    private final String host;
    private final int port;
    private final long lastSyncTimestampMillis;

    @JsonCreator
    public BrokerSyncStatus(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port, @JsonProperty(value="lastSyncTimestampMillis") long lastSyncTimestampMillis) {
        this.host = host;
        this.port = port;
        this.lastSyncTimestampMillis = lastSyncTimestampMillis;
    }

    public BrokerSyncStatus(ServiceLocation broker, long lastSyncTimestampMillis) {
        this.host = broker.getHost();
        this.port = broker.getTlsPort() > 0 ? broker.getTlsPort() : broker.getPlaintextPort();
        this.lastSyncTimestampMillis = lastSyncTimestampMillis;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public long getLastSyncTimestampMillis() {
        return this.lastSyncTimestampMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerSyncStatus that = (BrokerSyncStatus)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return "BrokerSyncStatus{host='" + this.host + "', port=" + this.port + ", lastSyncTimestampMillis=" + this.lastSyncTimestampMillis + "}";
    }
}

