/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.PairIterator;

abstract class HllPairIterator
extends PairIterator {
    final int lengthPairs;
    int index;
    int value;

    HllPairIterator(int lengthPairs) {
        this.lengthPairs = lengthPairs;
        this.index = -1;
    }

    @Override
    public String getHeader() {
        return String.format("%10s%6s", "Slot", "Value");
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getKey() {
        return this.index;
    }

    @Override
    public int getPair() {
        return HllUtil.pair(this.index, this.value);
    }

    @Override
    public int getSlot() {
        return this.index;
    }

    @Override
    public String getString() {
        int slot = this.getSlot();
        int value = this.getValue();
        return String.format("%10d%6d", slot, value);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public boolean nextAll() {
        if (++this.index < this.lengthPairs) {
            this.value = this.value();
            return true;
        }
        return false;
    }

    @Override
    public boolean nextValid() {
        while (++this.index < this.lengthPairs) {
            this.value = this.value();
            if (this.value == 0) continue;
            return true;
        }
        return false;
    }

    abstract int value();
}

