/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.druid.indexer.path.UsedSegmentsRetriever;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class OverlordActionBasedUsedSegmentsRetriever
implements UsedSegmentsRetriever {
    private final TaskToolbox toolbox;

    @Inject
    public OverlordActionBasedUsedSegmentsRetriever(TaskToolbox toolbox) {
        this.toolbox = (TaskToolbox)Preconditions.checkNotNull((Object)toolbox, (Object)"null task toolbox");
    }

    @Override
    public Collection<DataSegment> retrieveUsedSegmentsForIntervals(String dataSource, List<Interval> intervals, Segments visibility) throws IOException {
        return (Collection)this.toolbox.getTaskActionClient().submit((TaskAction)new RetrieveUsedSegmentsAction(dataSource, intervals, visibility));
    }
}

