/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datafactory.DataFactoryManager;
import com.azure.resourcemanager.datafactory.fluent.models.IntegrationRuntimeResourceInner;
import com.azure.resourcemanager.datafactory.implementation.Utils;
import com.azure.resourcemanager.datafactory.models.CreateLinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntime;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeAuthKeys;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeAutoUpdate;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeConnectionInfo;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeMonitoringData;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeRegenerateKeyParameters;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeResource;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeStatusResponse;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeRequest;
import com.azure.resourcemanager.datafactory.models.UpdateIntegrationRuntimeRequest;

public final class IntegrationRuntimeResourceImpl
implements IntegrationRuntimeResource,
IntegrationRuntimeResource.Definition,
IntegrationRuntimeResource.Update {
    private IntegrationRuntimeResourceInner innerObject;
    private final DataFactoryManager serviceManager;
    private String resourceGroupName;
    private String factoryName;
    private String integrationRuntimeName;
    private String createIfMatch;
    private UpdateIntegrationRuntimeRequest updateUpdateIntegrationRuntimeRequest;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public IntegrationRuntime properties() {
        return this.innerModel().properties();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public IntegrationRuntimeResourceInner innerModel() {
        return this.innerObject;
    }

    private DataFactoryManager manager() {
        return this.serviceManager;
    }

    @Override
    public IntegrationRuntimeResourceImpl withExistingFactory(String resourceGroupName, String factoryName) {
        this.resourceGroupName = resourceGroupName;
        this.factoryName = factoryName;
        return this;
    }

    @Override
    public IntegrationRuntimeResource create() {
        this.innerObject = (IntegrationRuntimeResourceInner)((Object)this.serviceManager.serviceClient().getIntegrationRuntimes().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, this.innerModel(), this.createIfMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public IntegrationRuntimeResource create(Context context) {
        this.innerObject = (IntegrationRuntimeResourceInner)((Object)this.serviceManager.serviceClient().getIntegrationRuntimes().createOrUpdateWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, this.innerModel(), this.createIfMatch, context).getValue());
        return this;
    }

    IntegrationRuntimeResourceImpl(String name, DataFactoryManager serviceManager) {
        this.innerObject = new IntegrationRuntimeResourceInner();
        this.serviceManager = serviceManager;
        this.integrationRuntimeName = name;
        this.createIfMatch = null;
    }

    @Override
    public IntegrationRuntimeResourceImpl update() {
        this.updateUpdateIntegrationRuntimeRequest = new UpdateIntegrationRuntimeRequest();
        return this;
    }

    @Override
    public IntegrationRuntimeResource apply() {
        this.innerObject = (IntegrationRuntimeResourceInner)((Object)this.serviceManager.serviceClient().getIntegrationRuntimes().updateWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, this.updateUpdateIntegrationRuntimeRequest, Context.NONE).getValue());
        return this;
    }

    @Override
    public IntegrationRuntimeResource apply(Context context) {
        this.innerObject = (IntegrationRuntimeResourceInner)((Object)this.serviceManager.serviceClient().getIntegrationRuntimes().updateWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, this.updateUpdateIntegrationRuntimeRequest, context).getValue());
        return this;
    }

    IntegrationRuntimeResourceImpl(IntegrationRuntimeResourceInner innerObject, DataFactoryManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.factoryName = Utils.getValueFromIdByName(innerObject.id(), "factories");
        this.integrationRuntimeName = Utils.getValueFromIdByName(innerObject.id(), "integrationRuntimes");
    }

    @Override
    public IntegrationRuntimeResource refresh() {
        String localIfNoneMatch = null;
        this.innerObject = (IntegrationRuntimeResourceInner)((Object)this.serviceManager.serviceClient().getIntegrationRuntimes().getWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, localIfNoneMatch, Context.NONE).getValue());
        return this;
    }

    @Override
    public IntegrationRuntimeResource refresh(Context context) {
        String localIfNoneMatch = null;
        this.innerObject = (IntegrationRuntimeResourceInner)((Object)this.serviceManager.serviceClient().getIntegrationRuntimes().getWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, localIfNoneMatch, context).getValue());
        return this;
    }

    @Override
    public Response<IntegrationRuntimeStatusResponse> getStatusWithResponse(Context context) {
        return this.serviceManager.integrationRuntimes().getStatusWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public IntegrationRuntimeStatusResponse getStatus() {
        return this.serviceManager.integrationRuntimes().getStatus(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public Response<IntegrationRuntimeConnectionInfo> getConnectionInfoWithResponse(Context context) {
        return this.serviceManager.integrationRuntimes().getConnectionInfoWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public IntegrationRuntimeConnectionInfo getConnectionInfo() {
        return this.serviceManager.integrationRuntimes().getConnectionInfo(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public Response<IntegrationRuntimeAuthKeys> regenerateAuthKeyWithResponse(IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters, Context context) {
        return this.serviceManager.integrationRuntimes().regenerateAuthKeyWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, regenerateKeyParameters, context);
    }

    @Override
    public IntegrationRuntimeAuthKeys regenerateAuthKey(IntegrationRuntimeRegenerateKeyParameters regenerateKeyParameters) {
        return this.serviceManager.integrationRuntimes().regenerateAuthKey(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, regenerateKeyParameters);
    }

    @Override
    public Response<IntegrationRuntimeAuthKeys> listAuthKeysWithResponse(Context context) {
        return this.serviceManager.integrationRuntimes().listAuthKeysWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public IntegrationRuntimeAuthKeys listAuthKeys() {
        return this.serviceManager.integrationRuntimes().listAuthKeys(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public IntegrationRuntimeStatusResponse start() {
        return this.serviceManager.integrationRuntimes().start(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public IntegrationRuntimeStatusResponse start(Context context) {
        return this.serviceManager.integrationRuntimes().start(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public void stop() {
        this.serviceManager.integrationRuntimes().stop(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public void stop(Context context) {
        this.serviceManager.integrationRuntimes().stop(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public Response<Void> syncCredentialsWithResponse(Context context) {
        return this.serviceManager.integrationRuntimes().syncCredentialsWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public void syncCredentials() {
        this.serviceManager.integrationRuntimes().syncCredentials(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public Response<IntegrationRuntimeMonitoringData> getMonitoringDataWithResponse(Context context) {
        return this.serviceManager.integrationRuntimes().getMonitoringDataWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public IntegrationRuntimeMonitoringData getMonitoringData() {
        return this.serviceManager.integrationRuntimes().getMonitoringData(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public Response<Void> upgradeWithResponse(Context context) {
        return this.serviceManager.integrationRuntimes().upgradeWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, context);
    }

    @Override
    public void upgrade() {
        this.serviceManager.integrationRuntimes().upgrade(this.resourceGroupName, this.factoryName, this.integrationRuntimeName);
    }

    @Override
    public Response<Void> removeLinksWithResponse(LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest, Context context) {
        return this.serviceManager.integrationRuntimes().removeLinksWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, linkedIntegrationRuntimeRequest, context);
    }

    @Override
    public void removeLinks(LinkedIntegrationRuntimeRequest linkedIntegrationRuntimeRequest) {
        this.serviceManager.integrationRuntimes().removeLinks(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, linkedIntegrationRuntimeRequest);
    }

    @Override
    public Response<IntegrationRuntimeStatusResponse> createLinkedIntegrationRuntimeWithResponse(CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest, Context context) {
        return this.serviceManager.integrationRuntimes().createLinkedIntegrationRuntimeWithResponse(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, createLinkedIntegrationRuntimeRequest, context);
    }

    @Override
    public IntegrationRuntimeStatusResponse createLinkedIntegrationRuntime(CreateLinkedIntegrationRuntimeRequest createLinkedIntegrationRuntimeRequest) {
        return this.serviceManager.integrationRuntimes().createLinkedIntegrationRuntime(this.resourceGroupName, this.factoryName, this.integrationRuntimeName, createLinkedIntegrationRuntimeRequest);
    }

    @Override
    public IntegrationRuntimeResourceImpl withProperties(IntegrationRuntime properties) {
        this.innerModel().withProperties(properties);
        return this;
    }

    @Override
    public IntegrationRuntimeResourceImpl withIfMatch(String ifMatch) {
        this.createIfMatch = ifMatch;
        return this;
    }

    @Override
    public IntegrationRuntimeResourceImpl withAutoUpdate(IntegrationRuntimeAutoUpdate autoUpdate) {
        this.updateUpdateIntegrationRuntimeRequest.withAutoUpdate(autoUpdate);
        return this;
    }

    @Override
    public IntegrationRuntimeResourceImpl withUpdateDelayOffset(String updateDelayOffset) {
        this.updateUpdateIntegrationRuntimeRequest.withUpdateDelayOffset(updateDelayOffset);
        return this;
    }
}

