/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.resourcemanager.storage.models.EnabledProtocols;
import com.azure.resourcemanager.storage.models.LeaseDuration;
import com.azure.resourcemanager.storage.models.LeaseState;
import com.azure.resourcemanager.storage.models.LeaseStatus;
import com.azure.resourcemanager.storage.models.RootSquashType;
import com.azure.resourcemanager.storage.models.ShareAccessTier;
import com.azure.resourcemanager.storage.models.SignedIdentifier;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class FileShareProperties {
    @JsonProperty(value="lastModifiedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastModifiedTime;
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> metadata;
    @JsonProperty(value="shareQuota")
    private Integer shareQuota;
    @JsonProperty(value="enabledProtocols")
    private EnabledProtocols enabledProtocols;
    @JsonProperty(value="rootSquash")
    private RootSquashType rootSquash;
    @JsonProperty(value="version", access=JsonProperty.Access.WRITE_ONLY)
    private String version;
    @JsonProperty(value="deleted", access=JsonProperty.Access.WRITE_ONLY)
    private Boolean deleted;
    @JsonProperty(value="deletedTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime deletedTime;
    @JsonProperty(value="remainingRetentionDays", access=JsonProperty.Access.WRITE_ONLY)
    private Integer remainingRetentionDays;
    @JsonProperty(value="accessTier")
    private ShareAccessTier accessTier;
    @JsonProperty(value="accessTierChangeTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime accessTierChangeTime;
    @JsonProperty(value="accessTierStatus", access=JsonProperty.Access.WRITE_ONLY)
    private String accessTierStatus;
    @JsonProperty(value="shareUsageBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long shareUsageBytes;
    @JsonProperty(value="leaseStatus", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseStatus leaseStatus;
    @JsonProperty(value="leaseState", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseState leaseState;
    @JsonProperty(value="leaseDuration", access=JsonProperty.Access.WRITE_ONLY)
    private LeaseDuration leaseDuration;
    @JsonProperty(value="signedIdentifiers")
    private List<SignedIdentifier> signedIdentifiers;
    @JsonProperty(value="snapshotTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime snapshotTime;

    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public FileShareProperties withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Integer shareQuota() {
        return this.shareQuota;
    }

    public FileShareProperties withShareQuota(Integer shareQuota) {
        this.shareQuota = shareQuota;
        return this;
    }

    public EnabledProtocols enabledProtocols() {
        return this.enabledProtocols;
    }

    public FileShareProperties withEnabledProtocols(EnabledProtocols enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
        return this;
    }

    public RootSquashType rootSquash() {
        return this.rootSquash;
    }

    public FileShareProperties withRootSquash(RootSquashType rootSquash) {
        this.rootSquash = rootSquash;
        return this;
    }

    public String version() {
        return this.version;
    }

    public Boolean deleted() {
        return this.deleted;
    }

    public OffsetDateTime deletedTime() {
        return this.deletedTime;
    }

    public Integer remainingRetentionDays() {
        return this.remainingRetentionDays;
    }

    public ShareAccessTier accessTier() {
        return this.accessTier;
    }

    public FileShareProperties withAccessTier(ShareAccessTier accessTier) {
        this.accessTier = accessTier;
        return this;
    }

    public OffsetDateTime accessTierChangeTime() {
        return this.accessTierChangeTime;
    }

    public String accessTierStatus() {
        return this.accessTierStatus;
    }

    public Long shareUsageBytes() {
        return this.shareUsageBytes;
    }

    public LeaseStatus leaseStatus() {
        return this.leaseStatus;
    }

    public LeaseState leaseState() {
        return this.leaseState;
    }

    public LeaseDuration leaseDuration() {
        return this.leaseDuration;
    }

    public List<SignedIdentifier> signedIdentifiers() {
        return this.signedIdentifiers;
    }

    public FileShareProperties withSignedIdentifiers(List<SignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
        return this;
    }

    public OffsetDateTime snapshotTime() {
        return this.snapshotTime;
    }

    public void validate() {
        if (this.signedIdentifiers() != null) {
            this.signedIdentifiers().forEach(e -> e.validate());
        }
    }
}

