/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.validator.resource;

import org.apache.dolphinscheduler.api.dto.resources.FetchFileContentDto;
import org.apache.dolphinscheduler.api.exceptions.ServiceException;
import org.apache.dolphinscheduler.api.validator.resource.AbstractResourceValidator;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.dao.repository.TenantDao;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.springframework.stereotype.Component;

@Component
public class FetchFileContentDtoValidator
extends AbstractResourceValidator<FetchFileContentDto> {
    public FetchFileContentDtoValidator(StorageOperator storageOperator, TenantDao tenantDao) {
        super(storageOperator, tenantDao);
    }

    @Override
    public void validate(FetchFileContentDto fetchFileContentDto) {
        if (fetchFileContentDto.getSkipLineNum() < 0) {
            throw new ServiceException("skipLineNum must be greater than or equal to 0");
        }
        String resourceFileAbsolutePath = fetchFileContentDto.getResourceFileAbsolutePath();
        User loginUser = fetchFileContentDto.getLoginUser();
        this.exceptionResourceAbsolutePathInvalidated(resourceFileAbsolutePath);
        this.exceptionResourceIsNotFile(resourceFileAbsolutePath);
        this.exceptionUserNoResourcePermission(loginUser, resourceFileAbsolutePath);
        this.exceptionFileContentCannotFetch(resourceFileAbsolutePath);
    }
}

