/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.ReflectionUtils;
import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class HeaderCollectionHandler {
    private static final int CACHE_SIZE_LIMIT = 10000;
    private static final Map<Field, MethodHandle> FIELD_TO_SETTER_CACHE = new ConcurrentHashMap<Field, MethodHandle>();
    private static final MethodHandle NO_SETTER_HANDLE = MethodHandles.identity(HeaderCollectionHandler.class);
    private final String prefix;
    private final int prefixLength;
    private final Map<String, String> values;
    private final Field declaringField;

    HeaderCollectionHandler(String prefix, Field declaringField) {
        this.prefix = prefix;
        this.prefixLength = prefix.length();
        this.values = new HashMap<String, String>();
        this.declaringField = declaringField;
    }

    boolean headerStartsWithPrefix(String headerName) {
        return headerName.startsWith(this.prefix);
    }

    void addHeader(String headerName, String headerValue) {
        this.values.put(headerName.substring(this.prefixLength), headerValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectValuesIntoDeclaringField(Object deserializedHeaders, ClientLogger logger) {
        if (this.usePublicSetter(deserializedHeaders, logger)) {
            return;
        }
        boolean declaredFieldAccessibleBackup = this.declaringField.isAccessible();
        try {
            if (!declaredFieldAccessibleBackup) {
                AccessController.doPrivileged(() -> {
                    this.declaringField.setAccessible(true);
                    return null;
                });
            }
            this.declaringField.set(deserializedHeaders, this.values);
            logger.verbose("Set header collection by accessing the field directly.");
        }
        catch (IllegalAccessException ex) {
            logger.warning("Failed to inject header collection values into deserialized headers.", ex);
        }
        finally {
            if (!declaredFieldAccessibleBackup) {
                AccessController.doPrivileged(() -> {
                    this.declaringField.setAccessible(false);
                    return null;
                });
            }
        }
    }

    private boolean usePublicSetter(Object deserializedHeaders, ClientLogger logger) {
        String fieldName;
        String clazzSimpleName;
        Class<?> clazz = deserializedHeaders.getClass();
        MethodHandle setterHandler = HeaderCollectionHandler.getFromCache(this.declaringField, clazz, clazzSimpleName = clazz.getSimpleName(), fieldName = this.declaringField.getName(), logger);
        if (setterHandler == NO_SETTER_HANDLE) {
            return false;
        }
        try {
            setterHandler.invokeWithArguments(deserializedHeaders, this.values);
            logger.verbose("Set header collection {} on class {} using MethodHandle.", fieldName, clazzSimpleName);
            return true;
        }
        catch (Throwable ex) {
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            logger.verbose("Failed to set header {} collection on class {} using MethodHandle.", fieldName, clazzSimpleName, ex);
            return false;
        }
    }

    private static String getPotentialSetterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
    }

    private static MethodHandle getFromCache(Field key, Class<?> clazz, String clazzSimpleName, String fieldName, ClientLogger logger) {
        if (FIELD_TO_SETTER_CACHE.size() >= 10000) {
            FIELD_TO_SETTER_CACHE.clear();
        }
        return FIELD_TO_SETTER_CACHE.computeIfAbsent(key, field -> {
            MethodHandles.Lookup lookupToUse;
            try {
                lookupToUse = ReflectionUtils.getLookupToUse(clazz);
            }
            catch (Exception ex) {
                logger.verbose("Failed to retrieve MethodHandles.Lookup for field {}. Will attempt to make field accessible.", field, ex);
                return NO_SETTER_HANDLE;
            }
            String setterName = HeaderCollectionHandler.getPotentialSetterName(fieldName);
            try {
                MethodHandle handle = lookupToUse.findVirtual(clazz, setterName, MethodType.methodType(clazz, Map.class));
                logger.verbose("Using MethodHandle for setter {} on class {}.", setterName, clazzSimpleName);
                return handle;
            }
            catch (ReflectiveOperationException ex) {
                logger.verbose("Failed to retrieve MethodHandle for setter {} on class {}. Will attempt to make field accessible. Please consider adding public setter.", setterName, clazzSimpleName, ex);
                try {
                    Method setterMethod = clazz.getDeclaredMethod(setterName, Map.class);
                    MethodHandle handle = lookupToUse.unreflect(setterMethod);
                    logger.verbose("Using unreflected MethodHandle for setter {} on class {}.", setterName, clazzSimpleName);
                    return handle;
                }
                catch (ReflectiveOperationException ex2) {
                    logger.verbose("Failed to unreflect MethodHandle for setter {} on class {}.Will attempt to make field accessible. Please consider adding public setter.", setterName, clazzSimpleName, ex2);
                    return NO_SETTER_HANDLE;
                }
            }
        });
    }
}

