/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.ProjectWorkerGroupRelationService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="PROJECT_WORKER_GROUP_TAG")
@RestController
@RequestMapping(value={"projects/{projectCode}/worker-group"})
public class ProjectWorkerGroupController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectWorkerGroupController.class);
    @Autowired
    private ProjectWorkerGroupRelationService projectWorkerGroupRelationService;

    @Operation(summary="assignWorkerGroups", description="ASSIGN_WORKER_GROUPS_NOTES")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="123456")), @Parameter(name="workerGroups", description="WORKER_GROUP_LIST", schema=@Schema(implementation=List.class))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.ASSIGN_WORKER_GROUP_TO_PROJECT_ERROR)
    public Result assignWorkerGroups(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode, @Parameter(name="workerGroups") String[] workerGroups) {
        List<String> workerGroupList = Arrays.stream(workerGroups).collect(Collectors.toList());
        return this.projectWorkerGroupRelationService.assignWorkerGroupsToProject(loginUser, projectCode, workerGroupList);
    }

    @Operation(summary="queryAssignedWorkerGroups", description="QUERY_WORKER_GROUP_LIST")
    @Parameters(value={@Parameter(name="projectCode", description="PROJECT_CODE", schema=@Schema(implementation=long.class, example="123456"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    public Map<String, Object> queryAssignedWorkerGroups(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @Parameter(name="projectCode", description="PROJECT_CODE", required=true) @PathVariable long projectCode) {
        return this.projectWorkerGroupRelationService.queryAssignedWorkerGroupsByProject(loginUser, projectCode);
    }
}

