/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.workqueue.ratelimiter;

import io.kubernetes.client.extended.workqueue.ratelimiter.BucketRateLimiter;
import io.kubernetes.client.extended.workqueue.ratelimiter.ItemExponentialFailureRateLimiter;
import io.kubernetes.client.extended.workqueue.ratelimiter.MaxOfRateLimiter;
import io.kubernetes.client.extended.workqueue.ratelimiter.RateLimiter;
import java.time.Duration;
import java.util.Arrays;

public class DefaultControllerRateLimiter<T>
implements RateLimiter<T> {
    private RateLimiter<T> internalRateLimiter = new MaxOfRateLimiter(Arrays.asList(new ItemExponentialFailureRateLimiter(Duration.ofMillis(5L), Duration.ofSeconds(1000L)), new BucketRateLimiter(100L, 10L, Duration.ofMinutes(1L))));

    @Override
    public Duration when(T item) {
        return this.internalRateLimiter.when(item);
    }

    @Override
    public void forget(T item) {
        this.internalRateLimiter.forget(item);
    }

    @Override
    public int numRequeues(T item) {
        return this.internalRateLimiter.numRequeues(item);
    }
}

