/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.FlowLogFormatParameters;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RetentionPolicyParameters;
import com.azure.resourcemanager.network.models.TrafficAnalyticsProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class FlowLogPropertiesFormat {
    @JsonProperty(value="targetResourceId", required=true)
    private String targetResourceId;
    @JsonProperty(value="targetResourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String targetResourceGuid;
    @JsonProperty(value="storageId", required=true)
    private String storageId;
    @JsonProperty(value="enabled")
    private Boolean enabled;
    @JsonProperty(value="retentionPolicy")
    private RetentionPolicyParameters retentionPolicy;
    @JsonProperty(value="format")
    private FlowLogFormatParameters format;
    @JsonProperty(value="flowAnalyticsConfiguration")
    private TrafficAnalyticsProperties flowAnalyticsConfiguration;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;
    private static final ClientLogger LOGGER = new ClientLogger(FlowLogPropertiesFormat.class);

    public String targetResourceId() {
        return this.targetResourceId;
    }

    public FlowLogPropertiesFormat withTargetResourceId(String targetResourceId) {
        this.targetResourceId = targetResourceId;
        return this;
    }

    public String targetResourceGuid() {
        return this.targetResourceGuid;
    }

    public String storageId() {
        return this.storageId;
    }

    public FlowLogPropertiesFormat withStorageId(String storageId) {
        this.storageId = storageId;
        return this;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public FlowLogPropertiesFormat withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public RetentionPolicyParameters retentionPolicy() {
        return this.retentionPolicy;
    }

    public FlowLogPropertiesFormat withRetentionPolicy(RetentionPolicyParameters retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public FlowLogFormatParameters format() {
        return this.format;
    }

    public FlowLogPropertiesFormat withFormat(FlowLogFormatParameters format) {
        this.format = format;
        return this;
    }

    public TrafficAnalyticsProperties flowAnalyticsConfiguration() {
        return this.flowAnalyticsConfiguration;
    }

    public FlowLogPropertiesFormat withFlowAnalyticsConfiguration(TrafficAnalyticsProperties flowAnalyticsConfiguration) {
        this.flowAnalyticsConfiguration = flowAnalyticsConfiguration;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.targetResourceId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property targetResourceId in model FlowLogPropertiesFormat"));
        }
        if (this.storageId() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageId in model FlowLogPropertiesFormat"));
        }
        if (this.retentionPolicy() != null) {
            this.retentionPolicy().validate();
        }
        if (this.format() != null) {
            this.format().validate();
        }
        if (this.flowAnalyticsConfiguration() != null) {
            this.flowAnalyticsConfiguration().validate();
        }
    }
}

