/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.resourcemanager.appservice.fluent.models.WorkflowProperties;
import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.Kind;
import com.azure.resourcemanager.appservice.models.ManagedServiceIdentity;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowResource;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

public final class Workflow
extends WorkflowResource {
    @JsonProperty(value="properties")
    private WorkflowProperties innerProperties;
    @JsonProperty(value="identity")
    private ManagedServiceIdentity identity;

    private WorkflowProperties innerProperties() {
        return this.innerProperties;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public Workflow withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    @Override
    public Workflow withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public Workflow withTags(Map<String, String> tags) {
        super.withTags((Map)tags);
        return this;
    }

    public WorkflowProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public OffsetDateTime changedTime() {
        return this.innerProperties() == null ? null : this.innerProperties().changedTime();
    }

    public WorkflowState state() {
        return this.innerProperties() == null ? null : this.innerProperties().state();
    }

    public Workflow withState(WorkflowState state) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withState(state);
        return this;
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public String accessEndpoint() {
        return this.innerProperties() == null ? null : this.innerProperties().accessEndpoint();
    }

    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().endpointsConfiguration();
    }

    public Workflow withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withEndpointsConfiguration(endpointsConfiguration);
        return this;
    }

    public FlowAccessControlConfiguration accessControl() {
        return this.innerProperties() == null ? null : this.innerProperties().accessControl();
    }

    public Workflow withAccessControl(FlowAccessControlConfiguration accessControl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withAccessControl(accessControl);
        return this;
    }

    public WorkflowSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public ResourceReference integrationAccount() {
        return this.innerProperties() == null ? null : this.innerProperties().integrationAccount();
    }

    public Workflow withIntegrationAccount(ResourceReference integrationAccount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withIntegrationAccount(integrationAccount);
        return this;
    }

    public ResourceReference integrationServiceEnvironment() {
        return this.innerProperties() == null ? null : this.innerProperties().integrationServiceEnvironment();
    }

    public Workflow withIntegrationServiceEnvironment(ResourceReference integrationServiceEnvironment) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withIntegrationServiceEnvironment(integrationServiceEnvironment);
        return this;
    }

    public Object definition() {
        return this.innerProperties() == null ? null : this.innerProperties().definition();
    }

    public Workflow withDefinition(Object definition) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withDefinition(definition);
        return this;
    }

    public Map<String, WorkflowParameter> parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public Workflow withParameters(Map<String, WorkflowParameter> parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public Kind kind() {
        return this.innerProperties() == null ? null : this.innerProperties().kind();
    }

    public Workflow withKind(Kind kind) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowProperties();
        }
        this.innerProperties().withKind(kind);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

