/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Loadable;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRegionPacker;
import com.terracottatech.frs.log.Signature;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Callable;

public class ChunkProcessing
implements Callable<List<LogRecord>> {
    private final Chunk base;
    private final String forceLogRegionFormat;

    public ChunkProcessing(Chunk base, String forceLogRegionFormat) {
        this.base = base;
        this.forceLogRegionFormat = forceLogRegionFormat;
    }

    @Override
    public List<LogRecord> call() throws Exception {
        if (this.base instanceof Loadable) {
            ((Loadable)((Object)this.base)).load();
        }
        try {
            List<LogRecord> records;
            List<LogRecord> list = records = LogRegionPacker.unpackInReverse(Signature.ADLER32, this.forceLogRegionFormat, this.base);
            return list;
        }
        finally {
            if (this.base instanceof Closeable) {
                ((Closeable)((Object)this.base)).close();
            }
        }
    }
}

