/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.events;

import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.SchemaChangeType;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class ViewChangeEvent {
    public final SchemaChangeType changeType;
    public final ViewMetadata oldView;
    public final ViewMetadata newView;

    public static ViewChangeEvent dropped(ViewMetadata oldView) {
        return new ViewChangeEvent(SchemaChangeType.DROPPED, oldView, null);
    }

    public static ViewChangeEvent created(ViewMetadata newView) {
        return new ViewChangeEvent(SchemaChangeType.CREATED, null, newView);
    }

    public static ViewChangeEvent updated(ViewMetadata oldView, ViewMetadata newView) {
        return new ViewChangeEvent(SchemaChangeType.UPDATED, oldView, newView);
    }

    private ViewChangeEvent(SchemaChangeType changeType, ViewMetadata oldView, ViewMetadata newView) {
        this.changeType = changeType;
        this.oldView = oldView;
        this.newView = newView;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ViewChangeEvent) {
            ViewChangeEvent that = (ViewChangeEvent)other;
            return this.changeType == that.changeType && Objects.equals(this.oldView, that.oldView) && Objects.equals(this.newView, that.newView);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.oldView, this.newView});
    }

    public String toString() {
        switch (this.changeType) {
            case CREATED: {
                return String.format("ViewChangeEvent(CREATED %s)", this.newView.getName());
            }
            case UPDATED: {
                return String.format("ViewChangeEvent(UPDATED %s=>%s)", this.oldView.getName(), this.newView.getName());
            }
            case DROPPED: {
                return String.format("ViewChangeEvent(DROPPED %s)", this.oldView.getName());
            }
        }
        throw new IllegalStateException("Unsupported change type " + (Object)((Object)this.changeType));
    }
}

