/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.addresstranslation;

import com.datastax.oss.driver.internal.core.addresstranslation.Subnet;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

class SubnetAddress {
    private final Subnet subnet;
    private final InetSocketAddress address;

    SubnetAddress(String subnetCIDR, InetSocketAddress address) {
        try {
            this.subnet = Subnet.parse(subnetCIDR);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.address = address;
    }

    InetSocketAddress getAddress() {
        return this.address;
    }

    boolean isOverlapping(SubnetAddress other) {
        Subnet thisSubnet = this.subnet;
        Subnet otherSubnet = other.subnet;
        return thisSubnet.contains(otherSubnet.getLower()) || thisSubnet.contains(otherSubnet.getUpper()) || otherSubnet.contains(thisSubnet.getLower()) || otherSubnet.contains(thisSubnet.getUpper());
    }

    boolean contains(InetSocketAddress address) {
        return this.subnet.contains(address.getAddress().getAddress());
    }

    boolean isIPv4() {
        return this.subnet.isIPv4();
    }

    boolean isIPv6() {
        return this.subnet.isIPv6();
    }

    public String toString() {
        return "SubnetAddress[subnet=" + this.subnet + ", address=" + this.address + "]";
    }
}

