/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.transports.storage.extensions;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import o.a.c.sidecar.client.shaded.common.data.RestoreJobSecrets;
import o.a.c.sidecar.client.shaded.common.request.data.UpdateRestoreJobRequestPayload;
import org.apache.cassandra.spark.bulkwriter.CancelJobEvent;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.apache.cassandra.spark.transports.storage.StorageCredentialPair;
import org.apache.cassandra.spark.transports.storage.extensions.CredentialChangeListener;
import org.apache.cassandra.spark.transports.storage.extensions.ObjectFailureListener;
import org.apache.cassandra.spark.transports.storage.extensions.TransportExtensionUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageTransportHandler
implements CredentialChangeListener,
ObjectFailureListener {
    private final TransportContext.CloudStorageTransportContext transportContext;
    private final Consumer<CancelJobEvent> cancelConsumer;
    private final JobInfo jobInfo;
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageTransportHandler.class);

    public StorageTransportHandler(TransportContext.CloudStorageTransportContext transportContext, JobInfo jobInfo, Consumer<CancelJobEvent> cancelConsumer) {
        this.transportContext = transportContext;
        this.jobInfo = jobInfo;
        this.cancelConsumer = cancelConsumer;
    }

    @Override
    public void onCredentialsChanged(String jobId, @Nullable String clusterId, StorageCredentialPair newCredentials) {
        TransportExtensionUtils.validateReceivedJobId(jobId, this.jobInfo);
        Preconditions.checkState((!this.jobInfo.isCoordinatedWriteEnabled() || clusterId != null ? 1 : 0) != 0, (Object)"ClusterId cannot be null for coordinated write enabled jobs");
        if (Objects.equals(this.transportContext.transportConfiguration().getStorageCredentialPair(clusterId), newCredentials)) {
            LOGGER.info("The received credentials have not changed. Skip updating. clusterId={}", (Object)clusterId);
            return;
        }
        LOGGER.info("Refreshing cloud storage credentials. jobId={} credentials={} clusterId={}", new Object[]{jobId, newCredentials, clusterId});
        this.transportContext.transportConfiguration().setStorageCredentialPair(clusterId, newCredentials);
        this.updateCredentials(clusterId, newCredentials);
    }

    @Override
    public void onObjectFailed(String jobId, String bucket, String key, String errorMessage) {
        TransportExtensionUtils.validateReceivedJobId(jobId, this.jobInfo);
        LOGGER.error("Object with bucket {} and key {} failed to be transported correctly. Cancelling job. Error was: {}", new Object[]{bucket, key, errorMessage});
        this.cancelConsumer.accept(new CancelJobEvent(errorMessage));
    }

    private void updateCredentials(@Nullable String clusterId, StorageCredentialPair credentialPair) {
        RestoreJobSecrets secrets = credentialPair.toRestoreJobSecrets();
        UpdateRestoreJobRequestPayload requestPayload = UpdateRestoreJobRequestPayload.builder().withSecrets(secrets).build();
        if (clusterId != null) {
            CoordinatedCloudStorageDataTransferApi dataTransferApi = (CoordinatedCloudStorageDataTransferApi)this.transportContext.dataTransferApi();
            ((CloudStorageDataTransferApiImpl)dataTransferApi.getValueOrThrow(clusterId)).updateRestoreJob(requestPayload);
        } else {
            this.transportContext.dataTransferApi().updateRestoreJob(requestPayload);
        }
    }
}

