/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.sparksql;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.CqlTable;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.data.TypeConverter;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.sparksql.CellIterator;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.PruneColumnFilter;
import org.apache.cassandra.spark.utils.FastThreadLocalUtf8Decoder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SparkCellIterator
extends CellIterator {
    private final DataLayer dataLayer;
    private final SparkType[] sparkTypes;

    public SparkCellIterator(int partitionId, @NotNull DataLayer dataLayer, @Nullable StructType requiredSchema, @NotNull List<PartitionKeyFilter> partitionKeyFilters) {
        super(partitionId, dataLayer.cqlTable(), dataLayer.stats(), (TypeConverter)dataLayer.typeConverter(), partitionKeyFilters, cqlTable -> SparkCellIterator.buildColumnFilter(requiredSchema, cqlTable), dataLayer::openCompactionScanner);
        this.dataLayer = dataLayer;
        this.sparkTypes = new SparkType[this.cqlTable.numFields()];
        SparkSqlTypeConverter sparkSqlTypeConverter = (SparkSqlTypeConverter)this.typeConverter;
        for (int index = 0; index < this.cqlTable.numFields(); ++index) {
            this.sparkTypes[index] = sparkSqlTypeConverter.toSparkType(this.cqlTable.field(index).type());
        }
    }

    @Nullable
    static PruneColumnFilter buildColumnFilter(@Nullable StructType requiredSchema, @NotNull CqlTable cqlTable) {
        return requiredSchema != null ? new PruneColumnFilter(Arrays.stream(requiredSchema.fields()).map(StructField::name).filter(arg_0 -> ((CqlTable)cqlTable).has(arg_0)).collect(Collectors.toSet())) : null;
    }

    public boolean isInPartition(int partitionId, BigInteger token, ByteBuffer partitionKey) {
        return this.dataLayer.isInPartition(partitionId, token, partitionKey);
    }

    public boolean equals(CqlField field, Object obj1, Object obj2) {
        return this.sparkTypes[field.position()].equals(obj1, obj2);
    }

    protected String decodeString(@Nullable ByteBuffer buffer) {
        return buffer != null ? FastThreadLocalUtf8Decoder.stringThrowRuntime((ByteBuffer)buffer) : null;
    }
}

