/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.cassandra.clients.Sidecar;
import org.apache.cassandra.secrets.SslConfig;
import org.apache.cassandra.spark.data.CassandraDataLayer;
import org.apache.cassandra.spark.data.ClientConfig;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.utils.MapUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CassandraDataSourceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraDataSourceHelper.class);
    public static final String CACHE_DATA_LAYER_KEY = "cacheDataLayer";
    private static Cache<Map<String, String>, CassandraDataLayer> cassandraDataLayerCache;
    public static final int CACHE_HOURS = 12;

    private CassandraDataSourceHelper() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    public static DataLayer getDataLayer(Map<String, String> options, BiConsumer<CassandraDataLayer, ClientConfig> initializeDataLayerFn) {
        ClientConfig config = ClientConfig.create(options);
        if (MapUtils.getBoolean(options, (String)CACHE_DATA_LAYER_KEY, (boolean)false)) {
            CassandraDataLayer cached;
            HashMap<String, String> key = new HashMap<String, String>(options);
            key.remove("createSnapshot");
            Cache<Map<String, String>, CassandraDataLayer> cassandraDataLayerCache = CassandraDataSourceHelper.getCassandraDataLayerCache();
            try {
                cached = (CassandraDataLayer)cassandraDataLayerCache.get(key, () -> CassandraDataSourceHelper.createAndInitCassandraDataLayer(config, options, initializeDataLayerFn, SparkContext.getOrCreate().getConf()));
            }
            catch (ExecutionException exception) {
                throw new RuntimeException("Unable to initialize CassandraDataLayer", exception);
            }
            return cached;
        }
        return CassandraDataSourceHelper.createAndInitCassandraDataLayer(config, options, initializeDataLayerFn, SparkContext.getOrCreate().getConf());
    }

    protected static Cache<Map<String, String>, CassandraDataLayer> getCassandraDataLayerCache() {
        if (cassandraDataLayerCache == null) {
            CassandraDataSourceHelper.initCassandraDataSourceCache(Ticker.systemTicker());
        }
        return cassandraDataLayerCache;
    }

    protected static void initCassandraDataSourceCache(Ticker ticker) {
        cassandraDataLayerCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterWrite(12L, TimeUnit.HOURS).removalListener(notification -> LOGGER.debug("Removed entry '{}' from CassandraDataSourceCache", notification.getValue())).build();
    }

    protected static CassandraDataLayer createAndInitCassandraDataLayer(ClientConfig config, Map<String, String> options, BiConsumer<CassandraDataLayer, ClientConfig> initializeDataLayerFn, SparkConf conf) {
        CassandraDataLayer dataLayer = new CassandraDataLayer(config, Sidecar.ClientConfig.create(options), SslConfig.create(options));
        initializeDataLayerFn.accept(dataLayer, config);
        dataLayer.startupValidate();
        return dataLayer;
    }
}

