/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

public class StorageClientConfig
implements Serializable {
    private static final long serialVersionUID = -1572678388713210328L;
    public final String threadNamePrefix;
    public final int concurrency;
    public final long threadKeepAliveSeconds;
    public final int maxChunkSizeInBytes;
    public final URI httpsProxy;
    public final long nioHttpClientConnectionAcquisitionTimeoutSeconds;
    public final int nioHttpClientMaxConcurrency;
    public final URI endpointOverride;

    public StorageClientConfig(int concurrency, long threadKeepAliveSeconds, int maxChunkSizeInBytes, String httpsProxy, String endpointOverride, long nioHttpClientConnectionAcquisitionTimeoutSeconds, int nioHttpClientMaxConcurrency) {
        this.threadNamePrefix = "storage-client";
        this.concurrency = concurrency;
        this.threadKeepAliveSeconds = threadKeepAliveSeconds;
        this.maxChunkSizeInBytes = maxChunkSizeInBytes;
        this.httpsProxy = this.toURI(httpsProxy, "HttpsProxy");
        this.endpointOverride = this.toURI(endpointOverride, "EndpointOverride");
        this.nioHttpClientConnectionAcquisitionTimeoutSeconds = nioHttpClientConnectionAcquisitionTimeoutSeconds;
        this.nioHttpClientMaxConcurrency = nioHttpClientMaxConcurrency;
    }

    private URI toURI(String uriString, String hint) {
        if (uriString == null) {
            return null;
        }
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(hint + " is specified, but the value is invalid. input=" + uriString, e);
        }
    }
}

