/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.Bundle;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.BundleNameGenerator;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.SSTableCollector;
import org.apache.cassandra.spark.common.Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTablesBundler
implements Iterator<Bundle> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSTablesBundler.class);
    private final SSTableCollector collector;
    private final BundleNameGenerator bundleNameGenerator;
    private final Path bundleStagingDir;
    private final long maxSizePerBundleInBytes;
    private boolean reachedEnd = false;
    private int bundleIndex = 0;
    private Bundle currentBundle = null;

    public SSTablesBundler(Path bundleStagingDir, SSTableCollector collector, BundleNameGenerator bundleNameGenerator, long maxSizePerBundleInBytes) {
        this.bundleStagingDir = bundleStagingDir;
        this.collector = collector;
        this.bundleNameGenerator = bundleNameGenerator;
        this.maxSizePerBundleInBytes = maxSizePerBundleInBytes;
    }

    @Override
    public boolean hasNext() {
        if (this.reachedEnd) {
            return !this.collector.isEmpty();
        }
        return this.collector.totalSize() > this.maxSizePerBundleInBytes;
    }

    @Override
    public Bundle next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Bundles have exhausted");
        }
        try {
            this.currentBundle = this.computeNext();
            return this.currentBundle;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to produce bundle", exception);
        }
    }

    public void includeDirectory(Path dir) {
        this.collector.includeDirectory(dir);
    }

    public void includeSSTable(List<Path> sstableComponents) {
        this.collector.includeSSTable(sstableComponents);
    }

    public void includeFileDigests(Map<Path, Digest> fileDigests) {
        this.collector.includeFileDigests(fileDigests);
    }

    public void finish() {
        this.reachedEnd = true;
    }

    public void cleanupBundle(String sessionID) {
        LOGGER.info("[{}]: Clean up bundle files after stream session bundle={}", (Object)sessionID, (Object)this.currentBundle);
        if (this.currentBundle == null) {
            return;
        }
        try {
            Bundle bundle = this.currentBundle;
            this.currentBundle = null;
            bundle.deleteAll();
        }
        catch (IOException exception) {
            LOGGER.warn("[{}]: Failed to clean up bundle files bundle={}", new Object[]{sessionID, this.currentBundle, exception});
        }
    }

    private Bundle computeNext() throws IOException {
        ArrayList<SSTableCollector.SSTableFilesAndRange> sstableFiles = new ArrayList<SSTableCollector.SSTableFilesAndRange>();
        HashMap<Path, Digest> fileDigests = new HashMap<Path, Digest>();
        long size = 0L;
        while (!this.collector.isEmpty()) {
            SSTableCollector.SSTableFilesAndRange sstable = this.collector.peek();
            long lastSize = size;
            if ((size += sstable.size) > this.maxSizePerBundleInBytes && lastSize != 0L) break;
            sstableFiles.add(sstable);
            fileDigests.putAll(this.collector.fileDigests(sstable.files));
            this.collector.consumeOne();
        }
        Files.createDirectories(this.bundleStagingDir, new FileAttribute[0]);
        return Bundle.builder().bundleSequence(this.bundleIndex++).bundleStagingDirectory(this.bundleStagingDir).sourceSSTables(sstableFiles).bundleNameGenerator(this.bundleNameGenerator).fileDigests(fileDigests).build();
    }

    static long zip(Path sourcePath, Path targetPath) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(targetPath, new OpenOption[0]));
             Stream<Path> stream = Files.walk(sourcePath, 1, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(sourcePath.relativize((Path)path).toString());
                try {
                    zos.putNextEntry(zipEntry);
                    Files.copy(path, zos);
                    zos.closeEntry();
                }
                catch (IOException e) {
                    LOGGER.error("Unexpected error while zipping file. path={}", path, (Object)e);
                    throw new RuntimeException(e);
                }
            });
        }
        return targetPath.toFile().length();
    }
}

