/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.spark.bulkwriter.BulkWriterContext;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.CommitResult;
import org.apache.cassandra.spark.bulkwriter.DirectDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.DirectStreamResult;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.RingInstance;
import org.apache.cassandra.spark.bulkwriter.TransportContext;
import org.apache.cassandra.util.ThreadUtil;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommitCoordinator
extends AbstractFuture<List<CommitResult>>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommitCoordinator.class);
    private final HashMap<RingInstance, ListeningExecutorService> executors = new HashMap();
    private final List<DirectStreamResult> successfulUploads;
    private final DirectDataTransferApi directDataTransferApi;
    private final ClusterInfo cluster;
    private final JobInfo job;
    private ListenableFuture<List<CommitResult>> allCommits;
    private final String jobSuffix;

    public static CommitCoordinator commit(BulkWriterContext writerContext, TransportContext.DirectDataBulkWriterContext transportContext, DirectStreamResult ... uploadResults) {
        CommitCoordinator coordinator = new CommitCoordinator(writerContext.cluster(), writerContext.job(), transportContext.dataTransferApi(), uploadResults);
        coordinator.commit();
        return coordinator;
    }

    private CommitCoordinator(ClusterInfo cluster, JobInfo job, DirectDataTransferApi dataTransferApi, DirectStreamResult[] uploadResults) {
        this.directDataTransferApi = dataTransferApi;
        this.cluster = cluster;
        this.job = job;
        this.jobSuffix = "-" + String.valueOf(job.getRestoreJobId());
        this.successfulUploads = Arrays.stream(uploadResults).filter(result -> !result.passed.isEmpty()).collect(Collectors.toList());
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        this.close();
        return this.allCommits == null || this.allCommits.cancel(mayInterruptIfRunning);
    }

    void commit() {
        if (!this.successfulUploads.isEmpty() && this.successfulUploads.stream().allMatch(result -> result.commitResults != null && !result.commitResults.isEmpty())) {
            List collect = this.successfulUploads.stream().flatMap(streamResult -> streamResult.commitResults.stream()).collect(Collectors.toList());
            this.set(collect);
            return;
        }
        Map<RingInstance, Map<String, Range<BigInteger>>> resultsByInstance = this.getResultsByInstance(this.successfulUploads);
        List commitFutures = resultsByInstance.entrySet().stream().flatMap(entry -> this.commit(this.executors, (RingInstance)entry.getKey(), (Map)entry.getValue())).collect(Collectors.toList());
        this.allCommits = Futures.allAsList(commitFutures);
        Futures.addCallback(this.allCommits, (FutureCallback)new FutureCallback<List<CommitResult>>(){

            public void onSuccess(@Nullable List<CommitResult> result) {
                CommitCoordinator.this.set(result);
            }

            public void onFailure(Throwable throwable) {
                CommitCoordinator.this.setException(throwable);
            }
        }, Runnable::run);
    }

    private Stream<ListenableFuture<CommitResult>> commit(Map<RingInstance, ListeningExecutorService> executors, RingInstance instance, Map<String, Range<BigInteger>> uploadRanges) {
        ListeningExecutorService executorService = executors.computeIfAbsent(instance, inst -> MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(this.job.getCommitThreadsPerInstance(), ThreadUtil.threadFactory((String)("commit-sstable-" + inst.nodeName())))));
        ArrayList<String> allUuids = new ArrayList<String>(uploadRanges.keySet());
        LOGGER.info("Committing UUIDs={}, Ranges={}, instance={}", new Object[]{allUuids, uploadRanges.values(), instance.nodeName()});
        List batches = Lists.partition(allUuids, (int)this.job.getCommitBatchSize());
        return batches.stream().map(uuids -> {
            String migrationId = UUID.randomUUID().toString();
            return executorService.submit(() -> {
                CommitResult commitResult = new CommitResult(migrationId, instance, uploadRanges);
                try {
                    DirectDataTransferApi.RemoteCommitResult result = this.directDataTransferApi.commitSSTables(instance, migrationId, (List<String>)uuids);
                    if (result.isSuccess) {
                        LOGGER.info("[{}]: Commit succeeded on {} for {}", new Object[]{migrationId, instance.nodeName(), uploadRanges});
                    } else {
                        LOGGER.error("[{}]: Commit failed: uploadRanges: {}, failedUuids: {}, stdErr: {}", new Object[]{migrationId, uploadRanges.entrySet(), result.failedUuids, result.stdErr});
                        if (!result.failedUuids.isEmpty()) {
                            this.addFailures(result.failedUuids, uploadRanges, commitResult, result.stdErr);
                        } else {
                            this.addFailures(uploadRanges, commitResult, result.stdErr);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.addFailures(uploadRanges, commitResult, throwable.toString());
                    this.cluster.refreshClusterInfo();
                }
                return commitResult;
            });
        });
    }

    private void addFailures(List<String> failedRanges, Map<String, Range<BigInteger>> uploadRanges, CommitResult commitResult, String error) {
        failedRanges.forEach(uuid -> {
            String shortUuid = uuid.replace(this.jobSuffix, "");
            commitResult.addFailedCommit(shortUuid, (Range<BigInteger>)((Range)uploadRanges.get(shortUuid)), error != null ? error : "Unknown Commit Failure");
        });
    }

    private void addFailures(Map<String, Range<BigInteger>> failedRanges, CommitResult commitResult, String message) {
        failedRanges.forEach((key, value) -> commitResult.addFailedCommit((String)key, (Range<BigInteger>)value, message));
        LOGGER.debug("Added failures to commitResult by Range: {}", (Object)commitResult);
    }

    private Map<RingInstance, Map<String, Range<BigInteger>>> getResultsByInstance(List<DirectStreamResult> successfulUploads) {
        return successfulUploads.stream().flatMap(upload -> upload.passed.stream().map(instance -> new AbstractMap.SimpleEntry<RingInstance, AbstractMap.SimpleEntry<String, Range>>((RingInstance)instance, new AbstractMap.SimpleEntry<String, Range>(upload.sessionID, upload.tokenRange)))).collect(Collectors.groupingBy(AbstractMap.SimpleEntry::getKey, Collectors.toMap(instance -> (String)((AbstractMap.SimpleEntry)instance.getValue()).getKey(), instance -> (Range)((AbstractMap.SimpleEntry)instance.getValue()).getValue())));
    }

    @Override
    public void close() {
        this.executors.values().forEach(ExecutorService::shutdownNow);
    }
}

