/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.cassandra.spark.bulkwriter.BroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.BulkSparkConf;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.IBroadcastableClusterInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.MultiClusterSupport;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BroadcastableClusterInfoGroup
implements IBroadcastableClusterInfo,
MultiClusterSupport<IBroadcastableClusterInfo> {
    private static final long serialVersionUID = 8621255452042082506L;
    private final List<BroadcastableClusterInfo> clusterInfos;
    private final String clusterId;
    private final BulkSparkConf conf;
    private final Partitioner partitioner;
    private final String lowestCassandraVersion;

    public static BroadcastableClusterInfoGroup from(@NotNull CassandraClusterInfoGroup source, @NotNull BulkSparkConf conf) {
        ArrayList<BroadcastableClusterInfo> broadcastableInfos = new ArrayList<BroadcastableClusterInfo>();
        source.forEach((String clusterId, ClusterInfo clusterInfo) -> broadcastableInfos.add(BroadcastableClusterInfo.from(clusterInfo, conf)));
        Partitioner partitioner = source.getPartitioner();
        String lowestVersion = source.getLowestCassandraVersion();
        return new BroadcastableClusterInfoGroup(broadcastableInfos, source.clusterId(), conf, partitioner, lowestVersion);
    }

    private BroadcastableClusterInfoGroup(List<BroadcastableClusterInfo> clusterInfos, String clusterId, BulkSparkConf conf, Partitioner partitioner, String lowestCassandraVersion) {
        this.clusterInfos = Collections.unmodifiableList(clusterInfos);
        this.conf = conf;
        this.clusterId = clusterId;
        this.partitioner = partitioner;
        this.lowestCassandraVersion = lowestCassandraVersion;
    }

    @Override
    @NotNull
    public BulkSparkConf getConf() {
        return this.conf;
    }

    @Override
    public String getLowestCassandraVersion() {
        return this.lowestCassandraVersion;
    }

    @Override
    public Partitioner getPartitioner() {
        return this.partitioner;
    }

    @Override
    public String clusterId() {
        return this.clusterId;
    }

    @Override
    public int size() {
        return this.clusterInfos.size();
    }

    @Override
    public void forEach(BiConsumer<String, IBroadcastableClusterInfo> action) {
        this.clusterInfos.forEach((? super T info) -> action.accept(info.clusterId(), (IBroadcastableClusterInfo)info));
    }

    @Override
    @Nullable
    public IBroadcastableClusterInfo getValueOrNull(@NotNull String clusterId) {
        throw new UnsupportedOperationException("getValueOrNull should not be called from BroadcastableClusterInfoGroup");
    }

    @Override
    public ClusterInfo reconstruct() {
        return CassandraClusterInfoGroup.from(this);
    }
}

