/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.kafka;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.apache.cassandra.cdc.api.KeyspaceTypeKey;
import org.apache.cassandra.cdc.avro.AvroDataUtils;
import org.apache.cassandra.cdc.avro.AvroGenericRecordTransformer;
import org.apache.cassandra.cdc.avro.msg.CdcEnvelope;
import org.apache.cassandra.cdc.kafka.KafkaCdcSerializer;
import org.apache.cassandra.cdc.msg.CdcEvent;
import org.apache.cassandra.cdc.schemastore.LocalTableSchemaStore;
import org.apache.cassandra.cdc.schemastore.SchemaStore;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.utils.ByteBufferUtils;
import org.apache.kafka.common.header.Headers;

public class AvroGenericRecordSerializer
implements KafkaCdcSerializer<CdcEvent> {
    private final BinaryEncoder encoderReuse;
    private final AvroGenericRecordTransformer recordTransformer;
    private final Deserializer deserializer;

    public AvroGenericRecordSerializer(Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, String schemaNamespacePrefix) {
        this(LocalTableSchemaStore.getInstance(), typeLookup, schemaNamespacePrefix);
    }

    public AvroGenericRecordSerializer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, String schemaNamespacePrefix) {
        this(schemaStore, typeLookup, 838860, schemaNamespacePrefix);
    }

    public AvroGenericRecordSerializer(SchemaStore schemaStore, Function<KeyspaceTypeKey, CqlField.CqlType> typeLookup, int truncateThreshold, String schemaNamespacePrefix) {
        this.recordTransformer = new AvroGenericRecordTransformer(schemaStore, typeLookup, truncateThreshold, schemaNamespacePrefix);
        this.encoderReuse = EncoderFactory.get().binaryEncoder((OutputStream)new ByteArrayOutputStream(65536), null);
        this.deserializer = new Deserializer(schemaStore);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public byte[] serialize(String topic, CdcEvent event) {
        GenericData.Record record = this.recordTransformer.transform(event);
        return this.encode((GenericDatumWriter<GenericRecord>)new GenericDatumWriter(record.getSchema()), record);
    }

    public byte[] serialize(String topic, Headers headers, CdcEvent data) {
        return this.serialize(topic, data);
    }

    public void close() {
    }

    private byte[] encode(GenericDatumWriter<GenericRecord> writer, GenericData.Record update) {
        return AvroDataUtils.encode(writer, update, this.encoderReuse);
    }

    @Override
    public AvroGenericRecordTransformer getTransformer() {
        return this.recordTransformer;
    }

    public Deserializer deserializer() {
        return this.deserializer;
    }

    @Deprecated
    public CdcEnvelope deserialize(String keyspace, String table, byte[] data, Schema schema) {
        return this.deserializer.deserialize(keyspace, table, data, schema);
    }

    public static class Deserializer {
        private final SchemaStore store;
        private final BinaryDecoder decoderReuse;

        public Deserializer(SchemaStore store) {
            this.store = store;
            this.decoderReuse = DecoderFactory.get().binaryDecoder((InputStream)new ByteArrayInputStream(ByteBufferUtils.EMPTY), null);
        }

        public CdcEnvelope deserialize(String keyspace, String table, byte[] data, Schema cdcSchema) {
            GenericDatumReader cdcReader = new GenericDatumReader(cdcSchema);
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, this.decoderReuse);
            try {
                GenericRecord header = (GenericRecord)cdcReader.read(null, (Decoder)decoder);
                GenericRecord payload = (GenericRecord)header.get("payload");
                return new CdcEnvelope(header, payload);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to deserialize CDC update from %s/%s", keyspace, table), e);
            }
        }

        Object deserializeRangePredicateValue(String keyspace, String table, String fieldName, ByteBuffer value) {
            GenericDatumReader<GenericRecord> reader = this.store.getReader(keyspace + "." + table, null);
            byte[] bytes = new byte[value.remaining()];
            try {
                value.get(bytes);
                BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, this.decoderReuse);
                GenericRecord valueRecord = (GenericRecord)reader.read(null, (Decoder)decoder);
                return valueRecord.get(fieldName);
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to deserialize CDC update from %s/%s", keyspace, table), e);
            }
        }
    }
}

