/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.avro;

import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.cdc.avro.AvroSchemas;
import org.apache.cassandra.cdc.avro.TypeConversion;
import org.apache.cassandra.cdc.avro.TypeConversionRegistry;
import org.jetbrains.annotations.NotNull;

public class RecordReader {
    private static final RecordReader INSTANCE = new RecordReader();
    private final TypeConversion.Registry registry = new TypeConversionRegistry();

    public static RecordReader get() {
        return INSTANCE;
    }

    private RecordReader() {
        this.registry.register(new TypeConversion.UUIDConversion());
        this.registry.register(new TypeConversion.DateConversion());
        this.registry.register(new TypeConversion.DecimalConversion());
        this.registry.register(new TypeConversion.TimestampConversion());
        this.registry.register(new TypeConversion.VarIntConversion());
        this.registry.register(new TypeConversion.InetAddressConversion());
        this.registry.register(new TypeConversion.SetConversion());
        this.registry.register(new TypeConversion.MapConversion());
        this.registry.register(new TypeConversion.ListConversion());
        this.registry.register(new TypeConversion.UdtConversion());
    }

    public Object read(GenericRecord genericRecord, String fieldName) {
        if (!genericRecord.hasField(fieldName)) {
            throw new NoSuchElementException("No such field: " + fieldName);
        }
        Object fieldValue = genericRecord.get(fieldName);
        if (fieldValue == null) {
            return null;
        }
        Schema fieldSchema = genericRecord.getSchema().getField(fieldName).schema();
        return this.convert(AvroSchemas.unwrapNullable((Schema)fieldSchema), fieldValue);
    }

    Object convert(Schema fieldSchema, @NotNull Object fieldValue) {
        TypeConversion<?> typeConversion = this.registry.lookup(fieldSchema);
        if (typeConversion != null) {
            return typeConversion.convert(fieldSchema, fieldValue);
        }
        if (fieldValue instanceof Utf8) {
            return fieldValue.toString();
        }
        return fieldValue;
    }
}

