/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.converter;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.data.CqlField;
import org.apache.cassandra.spark.data.converter.SparkSqlTypeConverter;
import org.apache.cassandra.spark.data.converter.types.Empty;
import org.apache.cassandra.spark.data.converter.types.SparkAscii;
import org.apache.cassandra.spark.data.converter.types.SparkBigInt;
import org.apache.cassandra.spark.data.converter.types.SparkBlob;
import org.apache.cassandra.spark.data.converter.types.SparkBoolean;
import org.apache.cassandra.spark.data.converter.types.SparkCounter;
import org.apache.cassandra.spark.data.converter.types.SparkDate;
import org.apache.cassandra.spark.data.converter.types.SparkDecimal;
import org.apache.cassandra.spark.data.converter.types.SparkDouble;
import org.apache.cassandra.spark.data.converter.types.SparkDuration;
import org.apache.cassandra.spark.data.converter.types.SparkFloat;
import org.apache.cassandra.spark.data.converter.types.SparkInet;
import org.apache.cassandra.spark.data.converter.types.SparkInt;
import org.apache.cassandra.spark.data.converter.types.SparkSmallInt;
import org.apache.cassandra.spark.data.converter.types.SparkText;
import org.apache.cassandra.spark.data.converter.types.SparkTime;
import org.apache.cassandra.spark.data.converter.types.SparkTimeUUID;
import org.apache.cassandra.spark.data.converter.types.SparkTimestamp;
import org.apache.cassandra.spark.data.converter.types.SparkTinyInt;
import org.apache.cassandra.spark.data.converter.types.SparkType;
import org.apache.cassandra.spark.data.converter.types.SparkUUID;
import org.apache.cassandra.spark.data.converter.types.SparkVarChar;
import org.apache.cassandra.spark.data.converter.types.SparkVarInt;
import org.apache.cassandra.spark.data.converter.types.complex.SparkFrozen;
import org.apache.cassandra.spark.data.converter.types.complex.SparkList;
import org.apache.cassandra.spark.data.converter.types.complex.SparkMap;
import org.apache.cassandra.spark.data.converter.types.complex.SparkSet;
import org.apache.cassandra.spark.data.converter.types.complex.SparkTuple;
import org.apache.cassandra.spark.data.converter.types.complex.SparkUdt;
import org.apache.cassandra.spark.data.types.Ascii;
import org.apache.cassandra.spark.data.types.BigInt;
import org.apache.cassandra.spark.data.types.Blob;
import org.apache.cassandra.spark.data.types.Boolean;
import org.apache.cassandra.spark.data.types.Counter;
import org.apache.cassandra.spark.data.types.Date;
import org.apache.cassandra.spark.data.types.Decimal;
import org.apache.cassandra.spark.data.types.Double;
import org.apache.cassandra.spark.data.types.Duration;
import org.apache.cassandra.spark.data.types.Float;
import org.apache.cassandra.spark.data.types.Inet;
import org.apache.cassandra.spark.data.types.Int;
import org.apache.cassandra.spark.data.types.SmallInt;
import org.apache.cassandra.spark.data.types.Text;
import org.apache.cassandra.spark.data.types.Time;
import org.apache.cassandra.spark.data.types.TimeUUID;
import org.apache.cassandra.spark.data.types.Timestamp;
import org.apache.cassandra.spark.data.types.TinyInt;
import org.apache.cassandra.spark.data.types.UUID;
import org.apache.cassandra.spark.data.types.VarChar;
import org.apache.cassandra.spark.data.types.VarInt;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.jetbrains.annotations.NotNull;

public class SparkSqlTypeConverterImplementation
implements SparkSqlTypeConverter {
    public static final SparkSqlTypeConverterImplementation INSTANCE = new SparkSqlTypeConverterImplementation();
    public static final Map<Class<? extends CqlField.CqlType>, SparkType> NATIVE_TYPES;

    public Object sparkSqlRowValue(CqlField.CqlType cqlType, GenericInternalRow row, int position) {
        return this.toSparkType(cqlType).sparkSqlRowValue(row, position);
    }

    public Object sparkSqlRowValue(CqlField.CqlType cqlType, Row row, int position) {
        return this.toSparkType(cqlType).sparkSqlRowValue(row, position);
    }

    public DataType sparkSqlType(CqlField.CqlType cqlType, BigNumberConfig bigNumberConfig) {
        return this.toSparkType(cqlType).dataType(bigNumberConfig);
    }

    public SparkType toSparkType(CqlField.CqlType cqlType) {
        return SparkSqlTypeConverterImplementation.getOrThrow(cqlType);
    }

    public Object convert(CqlField.CqlType cqlType, @NotNull Object value, boolean isFrozen) {
        return SparkSqlTypeConverterImplementation.getOrThrow(cqlType).toSparkSqlType(value, isFrozen);
    }

    protected static SparkType getOrThrow(CqlField.CqlType cqlType) {
        if (cqlType == null) {
            throw new NullPointerException("Null CqlType provided");
        }
        SparkType nativeSparkType = NATIVE_TYPES.get(cqlType.getClass());
        if (nativeSparkType != null) {
            return nativeSparkType;
        }
        if (cqlType.isFrozen()) {
            return new SparkFrozen((SparkSqlTypeConverter)INSTANCE, ((CqlField.CqlFrozen)cqlType).inner());
        }
        if (cqlType.isComplex()) {
            if (cqlType instanceof CqlField.CqlSet) {
                return new SparkSet((SparkSqlTypeConverter)INSTANCE, (CqlField.CqlSet)cqlType);
            }
            if (cqlType instanceof CqlField.CqlList) {
                return new SparkList((SparkSqlTypeConverter)INSTANCE, (CqlField.CqlCollection)((CqlField.CqlList)cqlType));
            }
            if (cqlType instanceof CqlField.CqlMap) {
                return new SparkMap((SparkSqlTypeConverter)INSTANCE, (CqlField.CqlMap)cqlType);
            }
            if (cqlType instanceof CqlField.CqlTuple) {
                return new SparkTuple((SparkSqlTypeConverter)INSTANCE, (CqlField.CqlTuple)cqlType);
            }
            if (cqlType instanceof CqlField.CqlUdt) {
                return new SparkUdt((SparkSqlTypeConverter)INSTANCE, (CqlField.CqlUdt)cqlType);
            }
            throw new IllegalStateException("Unexpected complex type: " + String.valueOf(cqlType));
        }
        return Objects.requireNonNull(nativeSparkType, String.format("No mapping from %s Cql native type to Spark type", cqlType.getClass().getName()));
    }

    static {
        HashMap<Class, Object> types = new HashMap<Class, Object>();
        types.put(Ascii.class, SparkAscii.INSTANCE);
        types.put(BigInt.class, SparkBigInt.INSTANCE);
        types.put(Blob.class, SparkBlob.INSTANCE);
        types.put(Boolean.class, SparkBoolean.INSTANCE);
        types.put(Counter.class, SparkCounter.INSTANCE);
        types.put(Date.class, SparkDate.INSTANCE);
        types.put(Decimal.class, SparkDecimal.INSTANCE);
        types.put(Double.class, SparkDouble.INSTANCE);
        types.put(Duration.class, SparkDuration.INSTANCE);
        types.put(org.apache.cassandra.spark.data.types.Empty.class, Empty.INSTANCE);
        types.put(Float.class, SparkFloat.INSTANCE);
        types.put(Inet.class, SparkInet.INSTANCE);
        types.put(Int.class, SparkInt.INSTANCE);
        types.put(SmallInt.class, SparkSmallInt.INSTANCE);
        types.put(Text.class, SparkText.INSTANCE);
        types.put(Time.class, SparkTime.INSTANCE);
        types.put(Timestamp.class, SparkTimestamp.INSTANCE);
        types.put(TimeUUID.class, SparkTimeUUID.INSTANCE);
        types.put(TinyInt.class, SparkTinyInt.INSTANCE);
        types.put(UUID.class, SparkUUID.INSTANCE);
        types.put(VarChar.class, SparkVarChar.INSTANCE);
        types.put(VarInt.class, SparkVarInt.INSTANCE);
        NATIVE_TYPES = ImmutableMap.copyOf(types);
    }
}

