/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.utils;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public interface AsyncExecutor {
    public <T> CompletableFuture<T> submit(Supplier<T> var1);

    public <T> CompletableFuture<Void> submit(Runnable var1);

    public <T> CompletableFuture<Void> schedule(Runnable var1, long var2);

    public long periodicTimer(Runnable var1, long var2);

    public boolean cancelTimer(long var1);

    public static AsyncExecutor wrap(ExecutorService executorService) {
        return new ExecutorServiceBased(executorService);
    }

    public static class ExecutorServiceBased
    implements AsyncExecutor {
        private final AtomicLong timerIds = new AtomicLong(0L);
        private final Map<Long, ScheduledFuture<?>> timerTasks = new ConcurrentHashMap();
        private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("scheduler-%d").setDaemon(true).build());
        private final ExecutorService executorService;

        public ExecutorServiceBased(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public <T> CompletableFuture<T> submit(Supplier<T> supplier) {
            return CompletableFuture.supplyAsync(supplier, this.executorService);
        }

        @Override
        public <T> CompletableFuture<Void> submit(Runnable blockingAction) {
            return CompletableFuture.runAsync(blockingAction, this.executorService);
        }

        @Override
        public <T> CompletableFuture<Void> schedule(Runnable action, long delayMillis) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            SCHEDULER.schedule(() -> this.submit(action).whenComplete((aVoid, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally((Throwable)throwable);
                } else {
                    future.complete((Void)aVoid);
                }
            }), delayMillis, TimeUnit.MILLISECONDS);
            return future;
        }

        @Override
        public long periodicTimer(Runnable action, long delayMillis) {
            long timerId = this.timerIds.getAndIncrement();
            ScheduledFuture<?> future = SCHEDULER.scheduleAtFixedRate(action, delayMillis, delayMillis, TimeUnit.MILLISECONDS);
            if (this.timerTasks.put(timerId, future) != null) {
                throw new IllegalStateException("Duplicate timerId: " + timerId);
            }
            return timerId;
        }

        @Override
        public boolean cancelTimer(long timerId) {
            ScheduledFuture<?> future = this.timerTasks.get(timerId);
            if (future != null) {
                return future.cancel(true);
            }
            return false;
        }
    }
}

