/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data.partitioner;

import java.nio.ByteBuffer;

public final class MurmurHash {
    private MurmurHash() {
        throw new IllegalStateException(String.valueOf(this.getClass()) + " is static utility class and shall not be instantiated");
    }

    private static long block(ByteBuffer key, int offset, int index) {
        int blockOffset = offset + (index << 3);
        return ((long)key.get(blockOffset + 0) & 0xFFL) + (((long)key.get(blockOffset + 1) & 0xFFL) << 8) + (((long)key.get(blockOffset + 2) & 0xFFL) << 16) + (((long)key.get(blockOffset + 3) & 0xFFL) << 24) + (((long)key.get(blockOffset + 4) & 0xFFL) << 32) + (((long)key.get(blockOffset + 5) & 0xFFL) << 40) + (((long)key.get(blockOffset + 6) & 0xFFL) << 48) + (((long)key.get(blockOffset + 7) & 0xFFL) << 56);
    }

    private static long rotate(long value, int shift) {
        return value << shift | value >>> 64 - shift;
    }

    private static long mix(long value) {
        value ^= value >>> 33;
        value *= -49064778989728563L;
        value ^= value >>> 33;
        value *= -4265267296055464877L;
        value ^= value >>> 33;
        return value;
    }

    public static long[] hash(ByteBuffer key, int offset, int length, long seed) {
        int nblocks = length >> 4;
        long h1 = seed;
        long h2 = seed;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        for (int block = 0; block < nblocks; ++block) {
            long k1 = MurmurHash.block(key, offset, block * 2 + 0);
            long k2 = MurmurHash.block(key, offset, block * 2 + 1);
            k1 *= c1;
            k1 = MurmurHash.rotate(k1, 31);
            h1 ^= (k1 *= c2);
            h1 = MurmurHash.rotate(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            k2 *= c2;
            k2 = MurmurHash.rotate(k2, 33);
            h2 ^= (k2 *= c1);
            h2 = MurmurHash.rotate(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        offset += nblocks * 16;
        long k1 = 0L;
        long k2 = 0L;
        switch (length & 0xF) {
            case 15: {
                k2 ^= (long)key.get(offset + 14) << 48;
            }
            case 14: {
                k2 ^= (long)key.get(offset + 13) << 40;
            }
            case 13: {
                k2 ^= (long)key.get(offset + 12) << 32;
            }
            case 12: {
                k2 ^= (long)key.get(offset + 11) << 24;
            }
            case 11: {
                k2 ^= (long)key.get(offset + 10) << 16;
            }
            case 10: {
                k2 ^= (long)key.get(offset + 9) << 8;
            }
            case 9: {
                k2 ^= (long)key.get(offset + 8);
                k2 *= c2;
                k2 = MurmurHash.rotate(k2, 33);
                h2 ^= (k2 *= c1);
            }
            case 8: {
                k1 ^= (long)key.get(offset + 7) << 56;
            }
            case 7: {
                k1 ^= (long)key.get(offset + 6) << 48;
            }
            case 6: {
                k1 ^= (long)key.get(offset + 5) << 40;
            }
            case 5: {
                k1 ^= (long)key.get(offset + 4) << 32;
            }
            case 4: {
                k1 ^= (long)key.get(offset + 3) << 24;
            }
            case 3: {
                k1 ^= (long)key.get(offset + 2) << 16;
            }
            case 2: {
                k1 ^= (long)key.get(offset + 1) << 8;
            }
            case 1: {
                k1 ^= (long)key.get(offset);
                k1 *= c1;
                k1 = MurmurHash.rotate(k1, 31);
                h1 ^= (k1 *= c2);
            }
        }
        h1 ^= (long)length;
        h1 += (h2 ^= (long)length);
        h2 += h1;
        h1 = MurmurHash.mix(h1);
        h2 = MurmurHash.mix(h2);
        h1 += h2;
        return new long[]{h1, h2 += h1};
    }
}

