/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cdc.api;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.bridge.CassandraVersion;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.utils.TimeUtils;

public interface CdcOptions {
    public static final CdcOptions DEFAULT = new CdcOptions(){};

    default public String dc() {
        return null;
    }

    default public Partitioner partitioner() {
        return Partitioner.Murmur3Partitioner;
    }

    default public boolean persistState() {
        return true;
    }

    default public Duration minimumDelayBetweenMicroBatches() {
        return Duration.ofMillis(1000L);
    }

    default public Duration sleepWhenInsufficientReplicas() {
        return Duration.ofSeconds(1L);
    }

    default public long microsecondProvider() {
        return TimeUtils.nowMicros();
    }

    default public long minimumTimestampMicros() {
        return this.microsecondProvider() - TimeUnit.NANOSECONDS.toMicros(this.maximumAge().toNanos());
    }

    default public Duration maximumAge() {
        return Duration.ofSeconds(3600L);
    }

    default public boolean discardOldMutations() {
        return true;
    }

    default public ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.LOCAL_QUORUM;
    }

    default public ReplicationFactor replicationFactor(String keyspace) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("class", "org.apache.cassandra.locator.SimpleStrategy");
        options.put("replication_factor", "3");
        return new ReplicationFactor(options);
    }

    default public int minimumReplicas(String keyspace) {
        return this.consistencyLevel().blockFor(this.replicationFactor(keyspace), this.dc());
    }

    default public Duration stopTimeout() {
        return Duration.ofMillis(3000L);
    }

    default public boolean isRunning() {
        return true;
    }

    default public long nextDelayMillis(long batchStartNanos) {
        return this.minimumDelayBetweenMicroBatches().toMillis() - TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - batchStartNanos);
    }

    default public int maxEpochs() {
        return -1;
    }

    default public int maxCommitLogsPerInstance() {
        return 4;
    }

    default public int maxCdcStateSize() {
        return 200000;
    }

    default public Double samplingRate() {
        return 0.0;
    }

    default public Duration schemaRefreshDelay() {
        return Duration.ofSeconds(30L);
    }

    default public CassandraVersion version() {
        return CassandraVersion.FOURZERO;
    }
}

