/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.bridge;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.cassandra.bridge.BigNumberConfig;
import org.apache.cassandra.spark.utils.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigNumberConfigImpl
implements BigNumberConfig,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BigNumberConfigImpl.class);
    private int bigIntegerPrecision;
    private int bigIntegerScale;
    private int bigDecimalPrecision;
    private int bigDecimalScale;

    @JsonCreator
    public BigNumberConfigImpl(@JsonProperty(value="bigIntegerPrecision") int bigIntegerPrecision, @JsonProperty(value="bigIntegerScale") int bigIntegerScale, @JsonProperty(value="bigDecimalPrecision") int bigDecimalPrecision, @JsonProperty(value="bigDecimalScale") int bigDecimalScale) {
        this.bigIntegerPrecision = bigIntegerPrecision;
        this.bigIntegerScale = bigIntegerScale;
        this.bigDecimalPrecision = bigDecimalPrecision;
        this.bigDecimalScale = bigDecimalScale;
    }

    public static BigNumberConfigImpl of(int bigIntegerPrecision, int bigIntegerScale, int bigDecimalPrecision, int bigDecimalScale) {
        return new BigNumberConfigImpl(bigIntegerPrecision, bigIntegerScale, bigDecimalPrecision, bigDecimalScale);
    }

    public static Map<String, BigNumberConfigImpl> build(Map<String, String> options) {
        return Optional.ofNullable(options.get(MapUtils.lowerCaseKey("bigNumberConfig"))).map(BigNumberConfigImpl::build).orElse(Collections.emptyMap());
    }

    public static Map<String, BigNumberConfigImpl> build(String bigNumberConfig) {
        TypeReference<HashMap<String, BigNumberConfigImpl>> typeRef = new TypeReference<HashMap<String, BigNumberConfigImpl>>(){};
        try {
            return (Map)new ObjectMapper().readValue(bigNumberConfig, (TypeReference)typeRef);
        }
        catch (IOException exception) {
            LOGGER.error("IOException could not read BigNumberConfig json", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    @JsonProperty
    public int bigIntegerPrecision() {
        return this.bigIntegerPrecision;
    }

    @Override
    @JsonProperty
    public int bigIntegerScale() {
        return this.bigIntegerScale;
    }

    @Override
    @JsonProperty
    public int bigDecimalPrecision() {
        return this.bigDecimalPrecision;
    }

    @Override
    @JsonProperty
    public int bigDecimalScale() {
        return this.bigDecimalScale;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bigIntegerPrecision, this.bigIntegerScale, this.bigDecimalPrecision, this.bigDecimalScale);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BigNumberConfigImpl that = (BigNumberConfigImpl)other;
        return this.bigIntegerPrecision == that.bigIntegerPrecision && this.bigIntegerScale == that.bigIntegerScale && this.bigDecimalPrecision == that.bigDecimalPrecision && this.bigDecimalScale == that.bigDecimalScale;
    }

    private void readObject(ObjectInputStream in) throws IOException {
        this.bigIntegerPrecision = in.readInt();
        this.bigIntegerScale = in.readInt();
        this.bigDecimalPrecision = in.readInt();
        this.bigDecimalScale = in.readInt();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.bigIntegerPrecision);
        out.writeInt(this.bigIntegerScale);
        out.writeInt(this.bigDecimalPrecision);
        out.writeInt(this.bigDecimalScale);
    }

    public static class Serializer
    extends com.esotericsoftware.kryo.Serializer<BigNumberConfigImpl> {
        public void write(Kryo kryo, Output out, BigNumberConfigImpl bigNumberConfig) {
            out.writeInt(bigNumberConfig.bigIntegerPrecision);
            out.writeInt(bigNumberConfig.bigIntegerScale);
            out.writeInt(bigNumberConfig.bigDecimalPrecision);
            out.writeInt(bigNumberConfig.bigDecimalScale);
        }

        public BigNumberConfigImpl read(Kryo kryo, Input input, Class<BigNumberConfigImpl> type) {
            return BigNumberConfigImpl.of(input.readInt(), input.readInt(), input.readInt(), input.readInt());
        }
    }
}

