/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.reader;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.spark.data.FileType;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.reader.CompressionMetadata;
import org.apache.cassandra.spark.reader.ReaderUtils;
import org.apache.cassandra.spark.reader.SummaryDbUtils;
import org.apache.cassandra.spark.utils.Pair;
import org.apache.cassandra.spark.utils.ThrowableUtils;
import org.apache.cassandra.utils.BloomFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSTableCache.class);
    public static final SSTableCache INSTANCE = new SSTableCache();
    private final Cache<SSTable, SummaryDbUtils.Summary> summary = this.buildCache(SSTableCache.propOrDefault("sbr.cache.summary.maxEntries", 4096), SSTableCache.propOrDefault("sbr.cache.summary.expireAfterMins", 15));
    private final Cache<SSTable, Pair<DecoratedKey, DecoratedKey>> index = this.buildCache(SSTableCache.propOrDefault("sbr.cache.index.maxEntries", 128), SSTableCache.propOrDefault("sbr.cache.index.expireAfterMins", 60));
    private final Cache<SSTable, Map<MetadataType, MetadataComponent>> stats = this.buildCache(SSTableCache.propOrDefault("sbr.cache.stats.maxEntries", 16384), SSTableCache.propOrDefault("sbr.cache.stats.expireAfterMins", 60));
    private final Cache<SSTable, BloomFilter> filter = this.buildCache(SSTableCache.propOrDefault("sbr.cache.filter.maxEntries", 16384), SSTableCache.propOrDefault("sbr.cache.filter.expireAfterMins", 60));
    private final Cache<SSTable, Optional<CompressionMetadata>> compressionMetadata = this.buildCache(SSTableCache.propOrDefault("sbr.cache.compressionInfo.maxEntries", 128), SSTableCache.propOrDefault("sbr.cache.compressionInfo.expireAfterMins", 15));

    private static int propOrDefault(String name, int defaultValue) {
        return SSTableCache.propOrDefault(name, defaultValue, Integer::parseInt);
    }

    private static long propOrDefault(String name, long defaultValue) {
        return SSTableCache.propOrDefault(name, defaultValue, Long::parseLong);
    }

    private static boolean propOrDefault(String name, boolean defaultValue) {
        return SSTableCache.propOrDefault(name, defaultValue, Boolean::parseBoolean);
    }

    private static <T> T propOrDefault(String name, T defaultValue, Function<String, T> parser) {
        String str = System.getProperty(name);
        if (str != null) {
            try {
                return parser.apply(str);
            }
            catch (NumberFormatException exception) {
                LOGGER.error("NumberFormatException for prop {} ", (Object)name, (Object)exception);
            }
        }
        return defaultValue;
    }

    private <T> Cache<SSTable, T> buildCache(int size, int expireAfterMins) {
        return CacheBuilder.newBuilder().expireAfterAccess((long)expireAfterMins, TimeUnit.MINUTES).maximumSize((long)size).build();
    }

    public SummaryDbUtils.Summary keysFromSummary(@NotNull TableMetadata metadata, @NotNull SSTable ssTable) throws IOException {
        return SSTableCache.get(this.summary, ssTable, () -> SummaryDbUtils.readSummary(metadata, ssTable));
    }

    @Nullable
    public Pair<DecoratedKey, DecoratedKey> keysFromIndex(@NotNull TableMetadata metadata, @NotNull SSTable ssTable) throws IOException {
        return SSTableCache.get(this.index, ssTable, () -> ReaderUtils.keysFromIndex(metadata, ssTable));
    }

    public Map<MetadataType, MetadataComponent> componentMapFromStats(@NotNull SSTable ssTable, Descriptor descriptor) throws IOException {
        return SSTableCache.get(this.stats, ssTable, () -> ReaderUtils.deserializeStatsMetadata(ssTable, descriptor));
    }

    public BloomFilter bloomFilter(@NotNull SSTable ssTable, Descriptor descriptor) throws IOException {
        return SSTableCache.get(this.filter, ssTable, () -> ReaderUtils.readFilter(ssTable, descriptor.version.hasOldBfFormat()));
    }

    @Nullable
    public CompressionMetadata compressionMetadata(@NotNull SSTable ssTable, boolean hasMaxCompressedLength, double crcCheckChance) throws IOException {
        long maxSize;
        if (SSTableCache.propOrDefault("sbr.cache.compressionInfo.enabled", true) && ((maxSize = SSTableCache.propOrDefault("sbr.cache.compressionInfo.maxSize", 0L)) <= 0L || ssTable.length(FileType.COMPRESSION_INFO) < maxSize)) {
            return SSTableCache.get(this.compressionMetadata, ssTable, () -> SSTableCache.readCompressionMetadata(ssTable, hasMaxCompressedLength, crcCheckChance)).orElse(null);
        }
        return SSTableCache.readCompressionMetadata(ssTable, hasMaxCompressedLength, crcCheckChance).orElse(null);
    }

    private static Optional<CompressionMetadata> readCompressionMetadata(@NotNull SSTable ssTable, boolean hasMaxCompressedLength, double crcCheckChance) throws IOException {
        try (InputStream cis = ssTable.openCompressionStream();){
            if (cis != null) {
                Optional<CompressionMetadata> optional = Optional.of(CompressionMetadata.fromInputStream(cis, hasMaxCompressedLength, crcCheckChance));
                return optional;
            }
        }
        return Optional.empty();
    }

    boolean containsSummary(@NotNull SSTable ssTable) {
        return SSTableCache.contains(this.summary, ssTable);
    }

    boolean containsIndex(@NotNull SSTable ssTable) {
        return SSTableCache.contains(this.index, ssTable);
    }

    boolean containsStats(@NotNull SSTable ssTable) {
        return SSTableCache.contains(this.stats, ssTable);
    }

    boolean containsCompressionMetadata(@NotNull SSTable ssTable) {
        return SSTableCache.contains(this.compressionMetadata, ssTable);
    }

    boolean containsFilter(@NotNull SSTable ssTable) {
        return SSTableCache.contains(this.filter, ssTable);
    }

    private static <T> boolean contains(@NotNull Cache<SSTable, T> cache, @NotNull SSTable ssTable) {
        return cache.getIfPresent((Object)ssTable) != null;
    }

    private static <T> T get(@NotNull Cache<SSTable, T> cache, @NotNull SSTable ssTable, @NotNull Callable<T> callable) throws IOException {
        try {
            return (T)cache.get((Object)ssTable, callable);
        }
        catch (ExecutionException exception) {
            throw SSTableCache.toIOException(exception);
        }
    }

    private static IOException toIOException(Throwable throwable) {
        IOException ioException = (IOException)ThrowableUtils.rootCause((Throwable)throwable, IOException.class);
        return ioException != null ? ioException : new IOException(ThrowableUtils.rootCause((Throwable)throwable));
    }
}

