/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.example;

import java.util.HashMap;
import java.util.UUID;
import org.apache.cassandra.spark.example.AbstractCassandraJob;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;

public class DirectWriteAndReadJob
extends AbstractCassandraJob {
    public static void main(String[] args) {
        System.setProperty("SKIP_STARTUP_VALIDATIONS", "true");
        new DirectWriteAndReadJob().start(args);
    }

    @Override
    protected AbstractCassandraJob.JobConfiguration configureJob(SparkContext sc, SparkConf sparkConf) {
        HashMap<String, String> writeOptions = new HashMap<String, String>();
        writeOptions.put("sidecar_contact_points", "localhost,localhost2,localhost3");
        writeOptions.put("keyspace", "spark_test");
        writeOptions.put("table", "test");
        writeOptions.put("local_dc", "datacenter1");
        writeOptions.put("bulk_writer_cl", "LOCAL_QUORUM");
        writeOptions.put("number_splits", "-1");
        writeOptions.put("data_transport", "DIRECT");
        int coresPerExecutor = sparkConf.getInt("spark.executor.cores", 1);
        int numExecutors = sparkConf.getInt("spark.dynamicAllocation.maxExecutors", sparkConf.getInt("spark.executor.instances", 1));
        int numCores = coresPerExecutor * numExecutors;
        HashMap<String, String> readerOptions = new HashMap<String, String>();
        readerOptions.put("sidecar_contact_points", "localhost,localhost2,localhost3");
        readerOptions.put("keyspace", "spark_test");
        readerOptions.put("table", "test");
        readerOptions.put("DC", "datacenter1");
        readerOptions.put("snapshotName", UUID.randomUUID().toString());
        readerOptions.put("createSnapshot", "true");
        readerOptions.put("defaultParallelism", String.valueOf(sc.defaultParallelism()));
        readerOptions.put("numCores", String.valueOf(numCores));
        readerOptions.put("sizing", "default");
        return new AbstractCassandraJob.JobConfiguration(writeOptions, readerOptions);
    }
}

