/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.util.List;
import org.gridkit.jvmtool.JvmProcessFilter;
import org.gridkit.jvmtool.JvmProcessPrinter;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.lab.jvm.attach.AttachManager;
import org.gridkit.lab.jvm.attach.JavaProcessId;

public class ProcListCmd
implements CommandLauncher.CmdRef {
    @Override
    public String getCommandName() {
        return "jps";
    }

    @Override
    public Runnable newCommand(CommandLauncher host) {
        return new JPS(host);
    }

    @Parameters(commandDescription="[JPS] Enhanced version of JDK's jps tool")
    public static class JPS
    implements Runnable {
        @ParametersDelegate
        private final CommandLauncher host;
        @ParametersDelegate
        private JvmProcessFilter filter = new JvmProcessFilter();
        @ParametersDelegate
        private JvmProcessPrinter printer = new JvmProcessPrinter();

        public JPS(CommandLauncher host) {
            this.host = host;
        }

        @Override
        public void run() {
            this.filter.prepare();
            List<JavaProcessId> procList = this.filter.isDefined() || this.printer.isDefined() ? AttachManager.listJavaProcesses(this.filter) : AttachManager.listJavaProcesses();
            for (JavaProcessId jpid : procList) {
                if (this.printer.isDefined()) {
                    System.out.println(this.printer.describe(jpid));
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(jpid.getPID()).append('\t');
                sb.append(jpid.getDescription());
                System.out.println(sb);
            }
        }
    }
}

