/*
 * Decompiled with CFR 0.152.
 */
package org.cliffc.high_scale_lib;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.cliffc.high_scale_lib.UtilUnsafe;
import sun.misc.Unsafe;

public class ConcurrentAutoTable
implements Serializable {
    private volatile CAT _cat = new CAT(null, 4, 0L);
    private static final AtomicReferenceFieldUpdater<ConcurrentAutoTable, CAT> _catUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcurrentAutoTable.class, CAT.class, "_cat");

    public void add(long x) {
        this.add_if_mask(x, 0L);
    }

    public void decrement() {
        this.add_if_mask(-1L, 0L);
    }

    public void increment() {
        this.add_if_mask(1L, 0L);
    }

    public void set(long x) {
        CAT newcat = new CAT(null, 4, x);
        while (!this.CAS_cat(this._cat, newcat)) {
        }
    }

    public long get() {
        return this._cat.sum(0L);
    }

    public int intValue() {
        return (int)this._cat.sum(0L);
    }

    public long longValue() {
        return this._cat.sum(0L);
    }

    public long estimate_get() {
        return this._cat.estimate_sum(0L);
    }

    public String toString() {
        return this._cat.toString(0L);
    }

    public void print() {
        this._cat.print();
    }

    public int internal_size() {
        return this._cat._t.length;
    }

    private long add_if_mask(long x, long mask) {
        return this._cat.add_if_mask(x, mask, ConcurrentAutoTable.hash(), this);
    }

    private boolean CAS_cat(CAT oldcat, CAT newcat) {
        return _catUpdater.compareAndSet(this, oldcat, newcat);
    }

    private static final int hash() {
        int h2 = System.identityHashCode(Thread.currentThread());
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        h2 ^= h2 >>> 7 ^ h2 >>> 4;
        return h2 << 2;
    }

    private static class CAT
    implements Serializable {
        private static final Unsafe _unsafe = UtilUnsafe.getUnsafe();
        private static final int _Lbase = _unsafe.arrayBaseOffset(long[].class);
        private static final int _Lscale = _unsafe.arrayIndexScale(long[].class);
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CAT> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CAT.class, "_resizers");
        private final CAT _next;
        private volatile long _sum_cache;
        private volatile long _fuzzy_sum_cache;
        private volatile long _fuzzy_time;
        private static final int MAX_SPIN = 2;
        private long[] _t;

        private static long rawIndex(long[] ary, int i) {
            assert (i >= 0 && i < ary.length);
            return _Lbase + i * _Lscale;
        }

        private static final boolean CAS(long[] A2, int idx, long old, long nnn) {
            return _unsafe.compareAndSwapLong(A2, CAT.rawIndex(A2, idx), old, nnn);
        }

        CAT(CAT next, int sz, long init) {
            this._next = next;
            this._sum_cache = Long.MIN_VALUE;
            this._t = new long[sz];
            this._t[0] = init;
        }

        public long add_if_mask(long x, long mask, int hash, ConcurrentAutoTable master) {
            long[] t2 = this._t;
            int idx = hash & t2.length - 1;
            long old = t2[idx];
            boolean ok = CAT.CAS(t2, idx, old & (mask ^ 0xFFFFFFFFFFFFFFFFL), old + x);
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
            if (ok) {
                return old;
            }
            if ((old & mask) != 0L) {
                return old;
            }
            int cnt = 0;
            while (true) {
                if (((old = t2[idx]) & mask) != 0L) {
                    return old;
                }
                if (CAT.CAS(t2, idx, old, old + x)) break;
                ++cnt;
            }
            if (cnt < 2) {
                return old;
            }
            if (t2.length >= 0x100000) {
                return old;
            }
            long r = this._resizers;
            int newbytes = t2.length << 1 << 3;
            while (!_resizerUpdater.compareAndSet(this, r, r + (long)newbytes)) {
                r = this._resizers;
            }
            r += (long)newbytes;
            if (master._cat != this) {
                return old;
            }
            if (r >> 17 != 0L) {
                try {
                    Thread.sleep(r >> 17);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (master._cat != this) {
                    return old;
                }
            }
            CAT newcat = new CAT(this, t2.length * 2, 0L);
            master.CAS_cat(this, newcat);
            return old;
        }

        public long sum(long mask) {
            long sum = this._sum_cache;
            if (sum != Long.MIN_VALUE) {
                return sum;
            }
            sum = this._next == null ? 0L : this._next.sum(mask);
            long[] t2 = this._t;
            for (int i = 0; i < t2.length; ++i) {
                sum += t2[i] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this._sum_cache = sum;
            return sum;
        }

        public long estimate_sum(long mask) {
            if (this._t.length <= 64) {
                return this.sum(mask);
            }
            long millis = System.currentTimeMillis();
            if (this._fuzzy_time != millis) {
                this._fuzzy_sum_cache = this.sum(mask);
                this._fuzzy_time = millis;
            }
            return this._fuzzy_sum_cache;
        }

        public void all_or(long mask) {
            long[] t2 = this._t;
            for (int i = 0; i < t2.length; ++i) {
                boolean done = false;
                while (!done) {
                    long old = t2[i];
                    done = CAT.CAS(t2, i, old, old | mask);
                }
            }
            if (this._next != null) {
                this._next.all_or(mask);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        public void all_and(long mask) {
            long[] t2 = this._t;
            for (int i = 0; i < t2.length; ++i) {
                boolean done = false;
                while (!done) {
                    long old = t2[i];
                    done = CAT.CAS(t2, i, old, old & mask);
                }
            }
            if (this._next != null) {
                this._next.all_and(mask);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        public void all_set(long val) {
            long[] t2 = this._t;
            for (int i = 0; i < t2.length; ++i) {
                t2[i] = val;
            }
            if (this._next != null) {
                this._next.all_set(val);
            }
            if (this._sum_cache != Long.MIN_VALUE) {
                this._sum_cache = Long.MIN_VALUE;
            }
        }

        String toString(long mask) {
            return Long.toString(this.sum(mask));
        }

        public void print() {
            long[] t2 = this._t;
            System.out.print("[sum=" + this._sum_cache + "," + t2[0]);
            for (int i = 1; i < t2.length; ++i) {
                System.out.print("," + t2[i]);
            }
            System.out.print("]");
            if (this._next != null) {
                this._next.print();
            }
        }
    }
}

