/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.utils.concurrent.BlockingQueues;
import org.apache.cassandra.utils.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightedQueue<T>
implements BlockingQueue<T> {
    private static final Logger logger = LoggerFactory.getLogger(WeightedQueue.class);
    public static final Weigher NATURAL_WEIGHER = weighable -> {
        if (weighable instanceof Weighable) {
            return ((Weighable)weighable).weight();
        }
        return 1;
    };
    private final Weigher<T> weigher;
    private final BlockingQueue<T> queue;
    private final int maxWeight;
    final Semaphore availableWeight;

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T t2) {
        Preconditions.checkNotNull(t2);
        boolean acquired = this.tryAcquireWeight(t2);
        if (acquired) {
            boolean offered = false;
            try {
                boolean bl = offered = this.queue.offer(t2);
                return bl;
            }
            finally {
                if (!offered) {
                    this.releaseWeight(t2);
                }
            }
        }
        return false;
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T poll() {
        Object retval = this.queue.poll();
        this.releaseWeight(retval);
        return (T)retval;
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(T t2) throws InterruptedException {
        Preconditions.checkNotNull(t2);
        this.acquireWeight(t2, 0L, null);
        boolean put = false;
        try {
            this.queue.put(t2);
            put = true;
        }
        finally {
            if (!put) {
                this.releaseWeight(t2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T t2, long timeout, TimeUnit unit) throws InterruptedException {
        Preconditions.checkNotNull(t2);
        Preconditions.checkNotNull(unit);
        boolean acquired = this.acquireWeight(t2, timeout, unit);
        if (acquired) {
            boolean offered = false;
            try {
                boolean bl = offered = this.queue.offer(t2, timeout, unit);
                return bl;
            }
            finally {
                if (!offered) {
                    this.releaseWeight(t2);
                }
            }
        }
        return false;
    }

    @Override
    public T take() throws InterruptedException {
        T retval = this.queue.take();
        this.releaseWeight(retval);
        return retval;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException("Seems like a bad idea");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException("Seems like a bad idea");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Seems like a bad idea");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Seems like a bad idea");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("Seems like a bad idea");
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        T o;
        int count;
        for (count = 0; count < maxElements && (o = this.poll()) != null; ++count) {
            c.add(o);
        }
        return count;
    }

    public WeightedQueue(int maxWeight) {
        this(maxWeight, BlockingQueues.newBlockingQueue(), NATURAL_WEIGHER);
    }

    public WeightedQueue(int maxWeight, BlockingQueue<T> queue, Weigher<T> weigher) {
        Preconditions.checkNotNull(queue);
        Preconditions.checkNotNull(weigher);
        Preconditions.checkArgument(maxWeight > 0);
        this.maxWeight = maxWeight;
        this.queue = queue;
        this.weigher = weigher;
        this.availableWeight = Semaphore.newSemaphore(maxWeight);
    }

    boolean acquireWeight(T weighable, long timeout, TimeUnit unit) throws InterruptedException {
        int weight = this.weigher.weigh(weighable);
        if (weight < 1) {
            throw new IllegalArgumentException(String.format("Weighable: \"%s\" had illegal weight %d", Objects.toString(weighable), weight));
        }
        weight = Math.min(this.maxWeight, weight);
        if (unit != null) {
            return this.availableWeight.tryAcquire(weight, timeout, unit);
        }
        this.availableWeight.acquire(weight);
        return true;
    }

    boolean tryAcquireWeight(T weighable) {
        int weight = this.weigher.weigh(weighable);
        if (weight < 1) {
            throw new IllegalArgumentException(String.format("Weighable: \"%s\" had illegal weight %d", Objects.toString(weighable), weight));
        }
        weight = Math.min(this.maxWeight, weight);
        return this.availableWeight.tryAcquire(weight);
    }

    void releaseWeight(T weighable) {
        if (weighable == null) {
            return;
        }
        int weight = this.weigher.weigh(weighable);
        if (weight < 1) {
            throw new IllegalArgumentException(String.format("Weighable: \"%s\" had illegal weight %d", Objects.toString(weighable), weight));
        }
        weight = Math.min(this.maxWeight, weight);
        this.availableWeight.release(weight);
    }

    public static interface Weighable {
        public int weight();
    }

    public static interface Weigher<T> {
        public int weigh(T var1);
    }
}

