/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.ArrayDeque;
import org.apache.cassandra.utils.concurrent.LightweightRecycler;

public final class ThreadLocals {
    private ThreadLocals() {
    }

    public static <T> LightweightRecycler<T> createLightweightRecycler(int limit) {
        return new FastThreadLocalLightweightRecycler(limit);
    }

    private static final class FastThreadLocalLightweightRecycler<T>
    extends FastThreadLocal<ArrayDeque<T>>
    implements LightweightRecycler<T> {
        private final int capacity;

        public FastThreadLocalLightweightRecycler(int capacity) {
            this.capacity = capacity;
        }

        @Override
        protected ArrayDeque<T> initialValue() {
            return new ArrayDeque(this.capacity);
        }

        @Override
        public int capacity() {
            return this.capacity;
        }
    }
}

