/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ExecutionFailure;
import org.apache.cassandra.concurrent.ExecutorPlus;
import org.apache.cassandra.concurrent.ImmediateExecutor;
import org.apache.cassandra.utils.concurrent.Future;
import org.apache.cassandra.utils.concurrent.IntrusiveStack;

abstract class ListenerList<V>
extends IntrusiveStack<ListenerList<V>> {
    ListenerList() {
    }

    abstract void notifySelf(Executor var1, Future<V> var2);

    static ListenerList pushHead(ListenerList prev, ListenerList next) {
        if (prev instanceof Notifying) {
            Notifying result = new Notifying();
            result.next = next;
            next.next = prev == Notifying.NOTIFYING ? null : prev;
            return result;
        }
        next.next = prev;
        return next;
    }

    static <T> void push(AtomicReferenceFieldUpdater<? super T, ListenerList> updater, T in, ListenerList newListener) {
        IntrusiveStack.push(updater, in, newListener, ListenerList::pushHead);
    }

    static <T> void pushExclusive(AtomicReferenceFieldUpdater<? super T, ListenerList> updater, T in, ListenerList newListener) {
        IntrusiveStack.pushExclusive(updater, in, newListener, ListenerList::pushHead);
    }

    static <V, T extends Future<V>> void notify(AtomicReferenceFieldUpdater<? super T, ListenerList> updater, T in) {
        ListenerList listeners;
        do {
            if ((listeners = updater.get(in)) != null && !(listeners instanceof Notifying)) continue;
            return;
        } while (!updater.compareAndSet(in, listeners, Notifying.NOTIFYING));
        while (true) {
            ListenerList.notifyExclusive(listeners, in);
            if (updater.compareAndSet(in, Notifying.NOTIFYING, null)) {
                return;
            }
            listeners = updater.getAndSet(in, Notifying.NOTIFYING);
        }
    }

    static <T> void notifyExclusive(ListenerList<T> head, Future<T> future) {
        Executor exec = future.notifyExecutor();
        Executor notifyExecutor = ListenerList.inExecutor(exec) ? null : exec;
        head = ListenerList.reverse(head);
        ListenerList.forEach(head, i -> i.notifySelf(notifyExecutor, future));
    }

    static <F extends io.netty.util.concurrent.Future<?>> void notifyListener(GenericFutureListener<F> listener, F future) {
        try {
            listener.operationComplete(future);
        }
        catch (Throwable t2) {
            ExecutionFailure.handle(t2);
        }
    }

    static <F extends io.netty.util.concurrent.Future<?>> void notifyListener(Executor notifyExecutor, GenericFutureListener<F> listener, F future) {
        if (notifyExecutor == null) {
            ListenerList.notifyListener(listener, future);
        } else {
            ListenerList.safeExecute(notifyExecutor, () -> ListenerList.notifyListener(listener, future));
        }
    }

    static void notifyListener(@Nullable Executor notifyExecutor, Runnable listener) {
        ListenerList.safeExecute(notifyExecutor, listener);
    }

    private static void safeExecute(@Nullable Executor notifyExecutor, Runnable runnable) {
        if (notifyExecutor == null) {
            notifyExecutor = ImmediateExecutor.INSTANCE;
        }
        try {
            notifyExecutor.execute(runnable);
        }
        catch (Error | Exception e) {
            ExecutionFailure.handle(e);
        }
    }

    static boolean inExecutor(Executor executor) {
        return executor instanceof EventExecutor && ((EventExecutor)executor).inEventLoop() || executor instanceof ExecutorPlus && ((ExecutorPlus)executor).inExecutor();
    }

    static class Notifying<V>
    extends ListenerList<V> {
        static final Notifying NOTIFYING = new Notifying();

        Notifying() {
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future<V> future) {
        }
    }

    static class RunnableWithExecutor<V>
    extends ListenerList<V> {
        final Runnable task;
        @Nullable
        final Executor executor;

        RunnableWithExecutor(Runnable task, @Nullable Executor executor) {
            this.task = task;
            this.executor = executor;
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future<V> future) {
            RunnableWithExecutor.notifyListener(RunnableWithExecutor.inExecutor(this.executor) ? null : this.executor, this.task);
        }
    }

    static class RunnableWithNotifyExecutor<V>
    extends ListenerList<V> {
        final Runnable task;

        RunnableWithNotifyExecutor(Runnable task) {
            this.task = task;
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future<V> future) {
            RunnableWithNotifyExecutor.notifyListener(notifyExecutor, this.task);
        }
    }

    static class CallbackLambdaListener<V>
    extends ListenerList<V>
    implements Runnable {
        final Future<V> future;
        final Consumer<? super V> onSuccess;
        final Consumer<? super Throwable> onFailure;
        final Executor executor;

        CallbackLambdaListener(Future<V> future, Consumer<? super V> onSuccess, Consumer<? super Throwable> onFailure, Executor executor) {
            this.future = future;
            this.onSuccess = onSuccess;
            this.onFailure = onFailure;
            this.executor = executor;
        }

        @Override
        public void run() {
            if (this.future.isSuccess()) {
                this.onSuccess.accept(this.future.getNow());
            } else {
                this.onFailure.accept(this.future.cause());
            }
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future future) {
            CallbackLambdaListener.notifyListener(this.executor == null ? notifyExecutor : this.executor, this);
        }
    }

    static class CallbackListenerWithExecutor<V>
    extends CallbackListener<V> {
        final Executor executor;

        CallbackListenerWithExecutor(Future<V> future, FutureCallback<? super V> callback, Executor executor) {
            super(future, callback);
            this.executor = executor;
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future<V> future) {
            CallbackListenerWithExecutor.notifyListener(this.executor, this);
        }
    }

    static class CallbackBiConsumerListener<V>
    extends ListenerList<V>
    implements Runnable {
        final Future<V> future;
        final BiConsumer<? super V, Throwable> callback;
        final Executor executor;

        CallbackBiConsumerListener(Future<V> future, BiConsumer<? super V, Throwable> callback, Executor executor) {
            this.future = future;
            this.callback = callback;
            this.executor = executor;
        }

        @Override
        public void run() {
            if (this.future.isSuccess()) {
                this.callback.accept(this.future.getNow(), null);
            } else {
                this.callback.accept(null, this.future.cause());
            }
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future<V> future) {
            CallbackBiConsumerListener.notifyListener(this.executor == null ? notifyExecutor : this.executor, this);
        }
    }

    static class CallbackListener<V>
    extends ListenerList<V>
    implements Runnable {
        final Future<V> future;
        final FutureCallback<? super V> callback;

        CallbackListener(Future<V> future, FutureCallback<? super V> callback) {
            this.future = future;
            this.callback = callback;
        }

        @Override
        public void run() {
            if (this.future.isSuccess()) {
                this.callback.onSuccess(this.future.getNow());
            } else {
                this.callback.onFailure(this.future.cause());
            }
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future<V> future) {
            CallbackListener.notifyListener(notifyExecutor, this);
        }
    }

    static class GenericFutureListenerList<V>
    extends ListenerList<V> {
        final GenericFutureListener listener;

        GenericFutureListenerList(GenericFutureListener listener) {
            this.listener = listener;
        }

        @Override
        void notifySelf(Executor notifyExecutor, Future<V> future) {
            GenericFutureListenerList.notifyListener(notifyExecutor, this.listener, future);
        }
    }
}

