/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.cassandra.utils.LongAccumulator;

public class IntrusiveStack<T extends IntrusiveStack<T>>
implements Iterable<T> {
    T next;

    protected static <O, T extends IntrusiveStack<T>> T push(AtomicReferenceFieldUpdater<? super O, T> headUpdater, O owner, T prepend) {
        return (T)IntrusiveStack.push(headUpdater, owner, prepend, (prev, next) -> {
            next.next = prev;
            return next;
        });
    }

    protected static <O, T extends IntrusiveStack<T>> T push(AtomicReferenceFieldUpdater<O, T> headUpdater, O owner, T prepend, BiFunction<T, T, T> combine) {
        IntrusiveStack head;
        while (!headUpdater.compareAndSet(owner, head = (IntrusiveStack)headUpdater.get(owner), (IntrusiveStack)combine.apply(head, prepend))) {
        }
        return (T)head;
    }

    protected static <O, T extends IntrusiveStack<T>> T push(Function<O, T> getter, Setter<O, T> setter, O owner, T prepend) {
        return (T)IntrusiveStack.push(getter, setter, owner, prepend, (prev, next) -> {
            next.next = prev;
            return next;
        });
    }

    protected static <O, T extends IntrusiveStack<T>> T push(Function<O, T> getter, Setter<O, T> setter, O owner, T prepend, BiFunction<T, T, T> combine) {
        IntrusiveStack head;
        while (!setter.compareAndSet(owner, head = (IntrusiveStack)getter.apply(owner), (IntrusiveStack)combine.apply(head, prepend))) {
        }
        return (T)head;
    }

    protected static <O, T extends IntrusiveStack<T>> void pushExclusive(AtomicReferenceFieldUpdater<O, T> headUpdater, O owner, T prepend, BiFunction<T, T, T> combine) {
        IntrusiveStack head = (IntrusiveStack)headUpdater.get(owner);
        headUpdater.lazySet(owner, (IntrusiveStack)combine.apply(head, prepend));
    }

    protected static <T extends IntrusiveStack<T>, O> void pushExclusive(AtomicReferenceFieldUpdater<O, T> headUpdater, O owner, T prepend) {
        prepend.next = (IntrusiveStack)headUpdater.get(owner);
        headUpdater.lazySet(owner, prepend);
    }

    protected static <T extends IntrusiveStack<T>> T pushExclusive(T head, T prepend) {
        prepend.next = head;
        return prepend;
    }

    protected static <T extends IntrusiveStack<T>, O> Iterable<T> iterable(AtomicReferenceFieldUpdater<O, T> headUpdater, O owner) {
        return IntrusiveStack.iterable((IntrusiveStack)headUpdater.get(owner));
    }

    protected static <T extends IntrusiveStack<T>> Iterable<T> iterable(T list) {
        return list == null ? () -> IntrusiveStack.iterator(null) : list;
    }

    protected static <T extends IntrusiveStack<T>> Iterator<T> iterator(T list) {
        return new Itr<T>(list);
    }

    protected static int size(IntrusiveStack<?> list) {
        int size = 0;
        while (list != null) {
            ++size;
            list = list.next;
        }
        return size;
    }

    protected static <T extends IntrusiveStack<T>> long accumulate(T list, LongAccumulator<T> accumulator, long initialValue) {
        long value = initialValue;
        while (list != null) {
            value = accumulator.apply(list, value);
            list = list.next;
        }
        return value;
    }

    protected T reverse() {
        return (T)IntrusiveStack.reverse(this);
    }

    protected static <T extends IntrusiveStack<T>> T reverse(T list) {
        T prev = null;
        T cur = list;
        while (cur != null) {
            T next = cur.next;
            cur.next = prev;
            prev = cur;
            cur = next;
        }
        return prev;
    }

    @Override
    public void forEach(Consumer<? super T> forEach) {
        IntrusiveStack.forEach(this, forEach);
    }

    protected static <T extends IntrusiveStack<T>> void forEach(T list, Consumer<? super T> forEach) {
        while (list != null) {
            forEach.accept(list);
            list = list.next;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Itr<IntrusiveStack>(this);
    }

    protected static interface Setter<O, T> {
        public boolean compareAndSet(O var1, T var2, T var3);
    }

    static class Itr<T extends IntrusiveStack<T>>
    implements Iterator<T> {
        private T next;

        Itr(T next) {
            this.next = next;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            T result = this.next;
            this.next = ((IntrusiveStack)result).next;
            return result;
        }
    }
}

