/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class NullableSerializer {
    public static <T> void serializeNullable(IVersionedSerializer<T> serializer, T value, DataOutputPlus out, int version) throws IOException {
        out.writeBoolean(value != null);
        if (value != null) {
            serializer.serialize(value, out, version);
        }
    }

    public static <T> T deserializeNullable(IVersionedSerializer<T> serializer, DataInputPlus in, int version) throws IOException {
        return in.readBoolean() ? (T)serializer.deserialize(in, version) : null;
    }

    public static <T> long serializedSizeNullable(IVersionedSerializer<T> serializer, T value, int version) {
        return value != null ? (long)TypeSizes.sizeof(true) + serializer.serializedSize(value, version) : (long)TypeSizes.sizeof(false);
    }

    public static <T> IVersionedSerializer<T> wrap(final IVersionedSerializer<T> wrap) {
        return new IVersionedSerializer<T>(){

            @Override
            public void serialize(T t2, DataOutputPlus out, int version) throws IOException {
                NullableSerializer.serializeNullable(wrap, t2, out, version);
            }

            @Override
            public T deserialize(DataInputPlus in, int version) throws IOException {
                return NullableSerializer.deserializeNullable(wrap, in, version);
            }

            @Override
            public long serializedSize(T t2, int version) {
                return NullableSerializer.serializedSizeNullable(wrap, t2, version);
            }
        };
    }
}

