/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.security.AbstractSslContextFactory;
import org.apache.cassandra.utils.Clock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBasedSslContextFactory
extends AbstractSslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(FileBasedSslContextFactory.class);
    protected FileBasedStoreContext keystoreContext;
    protected FileBasedStoreContext outboundKeystoreContext;
    protected FileBasedStoreContext trustStoreContext;
    protected volatile List<HotReloadableFile> hotReloadableFiles = new ArrayList<HotReloadableFile>();

    public FileBasedSslContextFactory() {
        this.keystoreContext = new FileBasedStoreContext("conf/.keystore", "cassandra");
        this.outboundKeystoreContext = new FileBasedStoreContext("conf/.keystore", "cassandra");
        this.trustStoreContext = new FileBasedStoreContext("conf/.truststore", "cassandra");
    }

    public FileBasedSslContextFactory(Map<String, Object> parameters) {
        super(parameters);
        this.keystoreContext = new FileBasedStoreContext(this.getString("keystore"), this.getString("keystore_password"));
        this.outboundKeystoreContext = new FileBasedStoreContext(StringUtils.defaultString((String)this.getString("outbound_keystore"), (String)this.keystoreContext.filePath), StringUtils.defaultString((String)this.getString("outbound_keystore_password"), (String)this.keystoreContext.password));
        this.trustStoreContext = new FileBasedStoreContext(this.getString("truststore"), this.getString("truststore_password"));
    }

    @Override
    public boolean shouldReload() {
        return this.hotReloadableFiles.stream().anyMatch(HotReloadableFile::shouldReload);
    }

    @Override
    public boolean hasKeystore() {
        return this.keystoreContext.hasKeystore();
    }

    @Override
    public boolean hasOutboundKeystore() {
        return this.outboundKeystoreContext.hasKeystore();
    }

    private boolean hasTruststore() {
        return this.trustStoreContext.filePath != null && new File(this.trustStoreContext.filePath).exists();
    }

    @Override
    public synchronized void initHotReloading() {
        boolean hasKeystore = this.hasKeystore();
        boolean hasOutboundKeystore = this.hasOutboundKeystore();
        boolean hasTruststore = this.hasTruststore();
        if (hasKeystore || hasOutboundKeystore || hasTruststore) {
            ArrayList<HotReloadableFile> fileList = new ArrayList<HotReloadableFile>();
            if (hasKeystore) {
                fileList.add(new HotReloadableFile(this.keystoreContext.filePath));
            }
            if (hasOutboundKeystore) {
                fileList.add(new HotReloadableFile(this.outboundKeystoreContext.filePath));
            }
            if (hasTruststore) {
                fileList.add(new HotReloadableFile(this.trustStoreContext.filePath));
            }
            this.hotReloadableFiles = fileList;
        }
    }

    protected void validatePassword(boolean isOutboundKeystore, String password) {
        if (password == null) {
            String keyName = isOutboundKeystore ? "outbound_" : "";
            String msg = String.format("'%skeystore_password' must be specified", keyName);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    protected KeyManagerFactory buildKeyManagerFactory() throws SSLException {
        this.validatePassword(false, this.keystoreContext.password);
        return this.getKeyManagerFactory(this.keystoreContext);
    }

    @Override
    protected KeyManagerFactory buildOutboundKeyManagerFactory() throws SSLException {
        this.validatePassword(true, this.outboundKeystoreContext.password);
        return this.getKeyManagerFactory(this.outboundKeystoreContext);
    }

    @Override
    protected TrustManagerFactory buildTrustManagerFactory() throws SSLException {
        TrustManagerFactory trustManagerFactory;
        block8: {
            InputStream tsf = Files.newInputStream(File.getPath(this.trustStoreContext.filePath, new String[0]), new OpenOption[0]);
            try {
                String algorithm = this.algorithm == null ? TrustManagerFactory.getDefaultAlgorithm() : this.algorithm;
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                KeyStore ts = KeyStore.getInstance(this.store_type);
                char[] truststorePassword = StringUtils.isEmpty((CharSequence)this.trustStoreContext.password) ? null : this.trustStoreContext.password.toCharArray();
                ts.load(tsf, truststorePassword);
                tmf.init(ts);
                trustManagerFactory = tmf;
                if (tsf == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tsf != null) {
                        try {
                            tsf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SSLException("failed to build trust manager store for secure connections", e);
                }
            }
            tsf.close();
        }
        return trustManagerFactory;
    }

    private KeyManagerFactory getKeyManagerFactory(FileBasedStoreContext context) throws SSLException {
        KeyManagerFactory keyManagerFactory;
        block9: {
            InputStream ksf = Files.newInputStream(File.getPath(context.filePath, new String[0]), new OpenOption[0]);
            try {
                String algorithm = this.algorithm == null ? KeyManagerFactory.getDefaultAlgorithm() : this.algorithm;
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
                KeyStore ks = KeyStore.getInstance(this.store_type);
                char[] password = context.password.toCharArray();
                ks.load(ksf, password);
                if (!context.checkedExpiry) {
                    this.checkExpiredCerts(ks);
                    context.checkedExpiry = true;
                }
                kmf.init(ks, password);
                keyManagerFactory = kmf;
                if (ksf == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ksf != null) {
                        try {
                            ksf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SSLException("failed to build key manager store for secure connections", e);
                }
            }
            ksf.close();
        }
        return keyManagerFactory;
    }

    protected boolean checkExpiredCerts(KeyStore ks) throws KeyStoreException {
        boolean hasExpiredCerts = false;
        Date now = new Date(Clock.Global.currentTimeMillis());
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            Date expires;
            String alias = aliases.nextElement();
            if (!ks.getCertificate(alias).getType().equals("X.509") || !(expires = ((X509Certificate)ks.getCertificate(alias)).getNotAfter()).before(now)) continue;
            hasExpiredCerts = true;
            logger.warn("Certificate for {} expired on {}", (Object)alias, (Object)expires);
        }
        return hasExpiredCerts;
    }

    protected static class FileBasedStoreContext {
        public volatile boolean checkedExpiry = false;
        public String filePath;
        public String password;

        public FileBasedStoreContext(String keystore, String keystorePassword) {
            this.filePath = keystore;
            this.password = keystorePassword;
        }

        protected boolean hasKeystore() {
            return this.filePath != null && new File(this.filePath).exists();
        }

        protected boolean passwordMatchesIfPresent(String keyPassword) {
            return StringUtils.isEmpty((CharSequence)this.password) || keyPassword.equals(this.password);
        }
    }

    protected static class HotReloadableFile {
        private final File file;
        private volatile long lastModTime;

        HotReloadableFile(String path) {
            this.file = new File(path);
            this.lastModTime = this.file.lastModified();
        }

        boolean shouldReload() {
            long curModTime = this.file.lastModified();
            boolean result = curModTime != this.lastModTime;
            this.lastModTime = curModTime;
            return result;
        }

        public String toString() {
            return "HotReloadableFile{file=" + this.file + ", lastModTime=" + this.lastModTime + "}";
        }
    }
}

