/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;
import org.apache.cassandra.streaming.PreviewKind;

public class SyncRequest
extends RepairMessage {
    public final InetAddressAndPort initiator;
    public final InetAddressAndPort src;
    public final InetAddressAndPort dst;
    public final Collection<Range<Token>> ranges;
    public final PreviewKind previewKind;
    public final boolean asymmetric;
    public static final IVersionedSerializer<SyncRequest> serializer = new IVersionedSerializer<SyncRequest>(){

        @Override
        public void serialize(SyncRequest message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(message.initiator, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(message.src, out, version);
            InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serialize(message.dst, out, version);
            out.writeInt(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                IPartitioner.validate(range);
                AbstractBounds.tokenSerializer.serialize(range, out, version);
            }
            out.writeInt(message.previewKind.getSerializationVal());
            out.writeBoolean(message.asymmetric);
        }

        @Override
        public SyncRequest deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = (RepairJobDesc)RepairJobDesc.serializer.deserialize(in, version);
            InetAddressAndPort initiator = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            InetAddressAndPort src = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            InetAddressAndPort dst = InetAddressAndPort.Serializer.inetAddressAndPortSerializer.deserialize(in, version);
            int rangesCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangesCount);
            for (int i = 0; i < rangesCount; ++i) {
                ranges.add((Range)AbstractBounds.tokenSerializer.deserialize(in, IPartitioner.global(), version));
            }
            PreviewKind previewKind = PreviewKind.deserialize(in.readInt());
            boolean asymmetric = in.readBoolean();
            return new SyncRequest(desc, initiator, src, dst, ranges, previewKind, asymmetric);
        }

        @Override
        public long serializedSize(SyncRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(message.initiator, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(message.src, version);
            size += InetAddressAndPort.Serializer.inetAddressAndPortSerializer.serializedSize(message.dst, version);
            size += (long)TypeSizes.sizeof(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                size += AbstractBounds.tokenSerializer.serializedSize(range, version);
            }
            size += (long)TypeSizes.sizeof(message.previewKind.getSerializationVal());
            return size += (long)TypeSizes.sizeof(message.asymmetric);
        }
    };

    public SyncRequest(RepairJobDesc desc, InetAddressAndPort initiator, InetAddressAndPort src, InetAddressAndPort dst, Collection<Range<Token>> ranges, PreviewKind previewKind, boolean asymmetric) {
        super(desc);
        this.initiator = initiator;
        this.src = src;
        this.dst = dst;
        this.ranges = ranges;
        this.previewKind = previewKind;
        this.asymmetric = asymmetric;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyncRequest)) {
            return false;
        }
        SyncRequest req = (SyncRequest)o;
        return this.desc.equals(req.desc) && this.initiator.equals(req.initiator) && this.src.equals(req.src) && this.dst.equals(req.dst) && this.ranges.equals(req.ranges) && this.previewKind == req.previewKind && this.asymmetric == req.asymmetric;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.desc, this.initiator, this.src, this.dst, this.ranges, this.previewKind});
    }

    public String toString() {
        return "SyncRequest{initiator=" + this.initiator + ", src=" + this.src + ", dst=" + this.dst + ", ranges=" + this.ranges + ", previewKind=" + this.previewKind + ", asymmetric=" + this.asymmetric + "} " + super.toString();
    }
}

