/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.consistent;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.cassandra.repair.SharedContext;
import org.apache.cassandra.repair.consistent.ConsistentSession;

public class LocalSession
extends ConsistentSession {
    public final long startedAt;
    private volatile long lastUpdate;

    public LocalSession(Builder builder) {
        super(builder);
        this.startedAt = builder.startedAt;
        this.lastUpdate = builder.lastUpdate;
    }

    public long getStartedAt() {
        return this.startedAt;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate() {
        this.lastUpdate = this.ctx.clock().nowInSeconds();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalSession session = (LocalSession)o;
        if (this.startedAt != session.startedAt) {
            return false;
        }
        return this.lastUpdate == session.lastUpdate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startedAt, this.lastUpdate);
    }

    @Override
    public String toString() {
        return "LocalSession{sessionID=" + this.sessionID + ", state=" + this.getState() + ", coordinator=" + this.coordinator + ", tableIds=" + this.tableIds + ", repairedAt=" + this.repairedAt + ", ranges=" + this.ranges + ", participants=" + this.participants + ", startedAt=" + this.startedAt + ", lastUpdate=" + this.lastUpdate + "}";
    }

    public static Builder builder(SharedContext ctx) {
        return new Builder(ctx);
    }

    public static class Builder
    extends ConsistentSession.AbstractBuilder {
        private long startedAt;
        private long lastUpdate;

        public Builder(SharedContext ctx) {
            super(ctx);
        }

        public Builder withStartedAt(long startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public Builder withLastUpdate(long lastUpdate) {
            this.lastUpdate = lastUpdate;
            return this;
        }

        @Override
        void validate() {
            super.validate();
            Preconditions.checkArgument(this.startedAt > 0L);
            Preconditions.checkArgument(this.lastUpdate > 0L);
        }

        public LocalSession build() {
            this.validate();
            return new LocalSession(this);
        }
    }
}

