/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import org.apache.cassandra.utils.Throwables;

final class PrunableArrayQueue<E> {
    private int capacity;
    private E[] buffer;
    private int mask;
    private int head = 0;
    private int tail = 0;

    PrunableArrayQueue(int requestedCapacity) {
        this.capacity = Math.max(8, PrunableArrayQueue.findNextPositivePowerOfTwo(requestedCapacity));
        this.mask = this.capacity - 1;
        this.buffer = new Object[this.capacity];
    }

    boolean offer(E e) {
        this.buffer[this.tail] = e;
        this.tail = this.tail + 1 & this.mask;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
        return true;
    }

    E peek() {
        return this.buffer[this.head];
    }

    E poll() {
        E result = this.buffer[this.head];
        if (null == result) {
            return null;
        }
        this.buffer[this.head] = null;
        this.head = this.head + 1 & this.mask;
        return result;
    }

    int size() {
        return this.tail - this.head & this.mask;
    }

    boolean isEmpty() {
        return this.head == this.tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int prune(Pruner<E> pruner) {
        int removed = 0;
        Throwable error = null;
        try {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                int k = this.tail - 1 - i & this.mask;
                E e = this.buffer[k];
                boolean shouldPrune = false;
                if (error == null) {
                    try {
                        shouldPrune = pruner.shouldPrune(e);
                    }
                    catch (Throwable t2) {
                        error = t2;
                    }
                }
                if (shouldPrune) {
                    this.buffer[k] = null;
                    ++removed;
                    try {
                        pruner.onPruned(e);
                    }
                    catch (Throwable t3) {
                        error = t3;
                    }
                    continue;
                }
                if (removed > 0) {
                    this.buffer[k + removed & this.mask] = e;
                    this.buffer[k] = null;
                }
                try {
                    pruner.onKept(e);
                    continue;
                }
                catch (Throwable t4) {
                    if (error != null) continue;
                    error = t4;
                }
            }
        }
        finally {
            this.head = this.head + removed & this.mask;
            if (error != null) {
                throw Throwables.unchecked(error);
            }
        }
        return removed;
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int newCapacity = this.capacity << 1;
        Object[] newBuffer = new Object[newCapacity];
        int headPortionLen = this.capacity - this.head;
        System.arraycopy(this.buffer, this.head, newBuffer, 0, headPortionLen);
        System.arraycopy(this.buffer, 0, newBuffer, headPortionLen, this.tail);
        this.head = 0;
        this.tail = this.capacity;
        this.capacity = newCapacity;
        this.mask = newCapacity - 1;
        this.buffer = newBuffer;
    }

    private static int findNextPositivePowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    public static interface Pruner<E> {
        public boolean shouldPrune(E var1);

        public void onPruned(E var1);

        public void onKept(E var1);
    }
}

