/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.metrics.Sampler;
import org.apache.cassandra.tools.nodetool.formatter.TableBuilder;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingManager {
    private static final Logger logger = LoggerFactory.getLogger(SamplingManager.class);
    private final ConcurrentHashMap<JobId, Future<?>> activeSamplingTasks = new ConcurrentHashMap();
    private final Set<JobId> cancelingTasks = ConcurrentHashMap.newKeySet();

    public static String formatResult(ResultBuilder resultBuilder) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintStream ps = new PrintStream(baos);){
            for (Sampler.SamplerType samplerType : Sampler.SamplerType.values()) {
                samplerType.format(resultBuilder, ps);
            }
            String string = baos.toString();
            return string;
        }
    }

    public static Iterable<ColumnFamilyStore> getTables(String ks, String table) {
        if (ks == null) {
            return ColumnFamilyStore.all();
        }
        Keyspace keyspace = Keyspace.open(ks);
        if (table == null) {
            return keyspace.getColumnFamilyStores();
        }
        return Collections.singletonList(keyspace.getColumnFamilyStore(table));
    }

    public boolean register(String ks, String table, int duration, int interval, int capacity, int count, List<String> samplers) {
        JobId jobId = new JobId(ks, table);
        logger.info("Registering samplers {} for {}", samplers, (Object)jobId);
        if (!this.canSchedule(jobId)) {
            logger.info("Unable to register {} due to existing ongoing sampling.", (Object)jobId);
            return false;
        }
        this.activeSamplingTasks.put(jobId, ScheduledExecutors.optionalTasks.submit(this.createSamplingBeginRunnable(jobId, SamplingManager.getTables(ks, table), duration, interval, capacity, count, samplers)));
        return true;
    }

    public boolean unregister(String ks, String table) {
        if (ks == null && table == null) {
            boolean res = true;
            for (JobId id : this.activeSamplingTasks.keySet()) {
                res = this.cancelTask(id) & res;
            }
            return res;
        }
        return this.cancelTask(new JobId(ks, table));
    }

    public List<String> allJobs() {
        return this.jobIds().stream().map(JobId::toString).collect(Collectors.toList());
    }

    private Set<JobId> jobIds() {
        HashSet<JobId> all = new HashSet<JobId>();
        all.addAll(this.activeSamplingTasks.keySet());
        all.addAll(this.cancelingTasks);
        return all;
    }

    private boolean canSchedule(JobId jobId) {
        Set<JobId> allJobIds = this.jobIds();
        if (allJobIds.contains(JobId.ALL_KS_AND_TABLES) || !allJobIds.isEmpty() && jobId.equals(JobId.ALL_KS_AND_TABLES)) {
            return false;
        }
        if (allJobIds.contains(jobId)) {
            return false;
        }
        return !allJobIds.contains(JobId.createForAllTables(jobId.keyspace));
    }

    private boolean cancelTask(JobId jobId) {
        Future task = (Future)this.activeSamplingTasks.remove(jobId);
        if (task != null) {
            this.cancelingTasks.add(jobId);
        }
        return task != null;
    }

    private Runnable createSamplingBeginRunnable(JobId jobId, Iterable<ColumnFamilyStore> tables, int duration, int interval, int capacity, int count, List<String> samplers) {
        return () -> {
            List tableNames = StreamSupport.stream(tables.spliterator(), false).map(cfs -> String.format("%s.%s", cfs.keyspace, cfs.name)).collect(Collectors.toList());
            logger.info("Starting to sample tables {} with the samplers {} for {} ms", new Object[]{tableNames, samplers, duration});
            for (String sampler : samplers) {
                for (ColumnFamilyStore cfs2 : tables) {
                    cfs2.beginLocalSampling(sampler, capacity, duration);
                }
            }
            ScheduledFuture<?> fut = ScheduledExecutors.optionalTasks.schedule(this.createSamplingEndRunnable(jobId, tables, duration, interval, capacity, count, samplers), (long)interval, TimeUnit.MILLISECONDS);
            this.activeSamplingTasks.put(jobId, fut);
        };
    }

    private Runnable createSamplingEndRunnable(JobId jobId, Iterable<ColumnFamilyStore> tables, int duration, int interval, int capacity, int count, List<String> samplers) {
        return () -> {
            HashMap<String, List<CompositeData>> results = new HashMap<String, List<CompositeData>>();
            for (String sampler : samplers) {
                ArrayList<CompositeData> topk = new ArrayList<CompositeData>();
                for (ColumnFamilyStore cfs : tables) {
                    try {
                        topk.addAll(cfs.finishLocalSampling(sampler, count));
                    }
                    catch (OpenDataException e) {
                        logger.warn("Failed to retrieve the sampled data. Abort the background sampling job: {}.", (Object)jobId, (Object)e);
                        this.activeSamplingTasks.remove(jobId);
                        this.cancelingTasks.remove(jobId);
                        return;
                    }
                }
                topk.sort((left, right) -> Long.compare((Long)right.get("count"), (Long)left.get("count")));
                topk = new ArrayList(topk.subList(0, Math.min(topk.size(), count)));
                results.put(sampler, topk);
            }
            AtomicBoolean first = new AtomicBoolean(false);
            ResultBuilder rb = new ResultBuilder(first, results, samplers);
            logger.info(SamplingManager.formatResult(rb));
            if (!this.cancelingTasks.contains(jobId)) {
                Future fut = ScheduledExecutors.optionalTasks.submit(this.createSamplingBeginRunnable(jobId, tables, duration, interval, capacity, count, samplers));
                this.activeSamplingTasks.put(jobId, fut);
            } else {
                logger.info("The sampling job {} has been cancelled.", (Object)jobId);
                this.activeSamplingTasks.remove(jobId);
                this.cancelingTasks.remove(jobId);
            }
        };
    }

    public static class ResultBuilder {
        protected Sampler.SamplerType type;
        protected String description;
        protected AtomicBoolean first;
        protected Map<String, List<CompositeData>> results;
        protected List<String> targets;
        protected List<Pair<String, String>> dataKeys;

        public ResultBuilder(AtomicBoolean first, Map<String, List<CompositeData>> results, List<String> targets) {
            this.first = first;
            this.results = results;
            this.targets = targets;
            this.dataKeys = new ArrayList<Pair<String, String>>();
            this.dataKeys.add(Pair.create("  ", "  "));
        }

        public ResultBuilder forType(Sampler.SamplerType type, String description) {
            ResultBuilder rb = new ResultBuilder(this.first, this.results, this.targets);
            rb.type = type;
            rb.description = description;
            return rb;
        }

        public ResultBuilder addColumn(String title, String key) {
            this.dataKeys.add(Pair.create(title, key));
            return this;
        }

        protected String get(CompositeData cd2, String key) {
            if (cd2.containsKey(key)) {
                return cd2.get(key).toString();
            }
            return key;
        }

        public void print(PrintStream ps) {
            if (this.targets.contains(this.type.toString())) {
                if (!this.first.get()) {
                    ps.println();
                }
                this.first.set(false);
                ps.println(this.description + ":");
                TableBuilder out = new TableBuilder();
                out.add(this.dataKeys.stream().map(p -> (String)p.left).collect(Collectors.toList()).toArray(new String[0]));
                List<CompositeData> topk = this.results.get(this.type.toString());
                for (CompositeData cd2 : topk) {
                    out.add(this.dataKeys.stream().map(p -> this.get(cd2, (String)p.right)).collect(Collectors.toList()).toArray(new String[0]));
                }
                if (topk.size() == 0) {
                    ps.println("   Nothing recorded during sampling period...");
                } else {
                    out.printTo(ps);
                }
            }
        }
    }

    private static class JobId {
        public static final JobId ALL_KS_AND_TABLES = new JobId(null, null);
        public final String keyspace;
        public final String table;

        public JobId(String ks, String tb) {
            this.keyspace = ks;
            this.table = tb;
        }

        public static JobId createForAllTables(String keyspace) {
            return new JobId(keyspace, null);
        }

        public String toString() {
            return this.maybeWildCard(this.keyspace) + "." + this.maybeWildCard(this.table);
        }

        private String maybeWildCard(String input) {
            return input == null ? "*" : input;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JobId jobId = (JobId)o;
            return Objects.equals(this.keyspace, jobId.keyspace) && Objects.equals(this.table, jobId.table);
        }

        public int hashCode() {
            return Objects.hash(this.keyspace, this.table);
        }
    }
}

