/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.RateLimiter;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.WrappingRebufferer;

@NotThreadSafe
public class LimitingRebufferer
extends WrappingRebufferer {
    private final RateLimiter limiter;
    private final int limitQuant;

    public LimitingRebufferer(Rebufferer wrapped, RateLimiter limiter, int limitQuant) {
        super(wrapped);
        this.limiter = limiter;
        this.limitQuant = limitQuant;
    }

    @Override
    public Rebufferer.BufferHolder rebuffer(long position) {
        super.rebuffer(position);
        int posInBuffer = Ints.checkedCast(position - this.offset);
        int remaining = this.buffer.limit() - posInBuffer;
        if (remaining == 0) {
            return this;
        }
        if (remaining > this.limitQuant) {
            this.buffer.limit(posInBuffer + this.limitQuant);
            remaining = this.limitQuant;
        }
        this.limiter.acquire(remaining);
        return this;
    }

    @Override
    public String toString() {
        return "LimitingRebufferer[" + this.limiter + "]:" + this.wrapped;
    }
}

