/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Set;
import org.apache.cassandra.io.FSReadError;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.TOCComponent;
import org.apache.cassandra.io.util.File;

public class CompressionInfoComponent {
    public static CompressionMetadata maybeLoad(Descriptor descriptor, Set<Component> components) {
        if (components.contains(SSTableFormat.Components.COMPRESSION_INFO)) {
            return CompressionInfoComponent.load(descriptor);
        }
        return null;
    }

    public static CompressionMetadata loadIfExists(Descriptor descriptor) {
        if (descriptor.fileFor(SSTableFormat.Components.COMPRESSION_INFO).exists()) {
            return CompressionInfoComponent.load(descriptor);
        }
        return null;
    }

    public static CompressionMetadata load(Descriptor descriptor) {
        return CompressionMetadata.open(descriptor.fileFor(SSTableFormat.Components.COMPRESSION_INFO), descriptor.fileFor(SSTableFormat.Components.DATA).length(), descriptor.version.hasMaxCompressedLength());
    }

    public static void verifyCompressionInfoExistenceIfApplicable(Descriptor descriptor, Set<Component> actualComponents) throws CorruptSSTableException, FSReadError {
        File tocFile = descriptor.fileFor(SSTableFormat.Components.TOC);
        if (tocFile.exists()) {
            try {
                Set<Component> expectedComponents = TOCComponent.loadTOC(descriptor, false);
                if (expectedComponents.contains(SSTableFormat.Components.COMPRESSION_INFO) && !actualComponents.contains(SSTableFormat.Components.COMPRESSION_INFO)) {
                    File compressionInfoFile = descriptor.fileFor(SSTableFormat.Components.COMPRESSION_INFO);
                    throw new CorruptSSTableException((Throwable)new NoSuchFileException(compressionInfoFile.absolutePath()), compressionInfoFile);
                }
            }
            catch (IOException e) {
                throw new FSReadError((Throwable)e, tocFile);
            }
        }
    }
}

