/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.lifecycle.Tracker;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.IOOptions;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.TOCComponent;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TableMetadataRef;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.TimeUUID;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class SSTable {
    public static final int TOMBSTONE_HISTOGRAM_BIN_SIZE = 100;
    public static final int TOMBSTONE_HISTOGRAM_SPOOL_SIZE = 100000;
    public static final int TOMBSTONE_HISTOGRAM_TTL_ROUND_SECONDS = CassandraRelevantProperties.STREAMING_HISTOGRAM_ROUND_SECONDS.getInt();
    public final Descriptor descriptor;
    protected final Set<Component> components;
    public final boolean compression;
    protected final TableMetadataRef metadata;
    public final ChunkCache chunkCache;
    public final IOOptions ioOptions;
    @Nullable
    private final WeakReference<Owner> owner;

    public SSTable(Builder<?, ?> builder, Owner owner) {
        this.owner = new WeakReference<Owner>(owner);
        Preconditions.checkNotNull(builder.descriptor);
        Preconditions.checkNotNull(builder.getComponents());
        this.descriptor = builder.descriptor;
        this.ioOptions = builder.getIOOptions();
        this.components = new CopyOnWriteArraySet<Component>(builder.getComponents());
        this.compression = this.components.contains(SSTableFormat.Components.COMPRESSION_INFO);
        this.metadata = builder.getTableMetadataRef();
        this.chunkCache = builder.getChunkCache();
    }

    public final Optional<Owner> owner() {
        if (this.owner == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Owner)this.owner.get());
    }

    public static void rename(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        components.stream().filter(c -> !newdesc.getFormat().generatedOnLoadComponents().contains(c)).filter(c -> !c.equals(SSTableFormat.Components.DATA)).forEach(c -> tmpdesc.fileFor((Component)c).move(newdesc.fileFor((Component)c)));
        tmpdesc.fileFor(SSTableFormat.Components.DATA).move(newdesc.fileFor(SSTableFormat.Components.DATA));
        components.stream().filter(c -> newdesc.getFormat().generatedOnLoadComponents().contains(c)).forEach(c -> tmpdesc.fileFor((Component)c).tryMove(newdesc.fileFor((Component)c)));
    }

    public static void copy(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        components.stream().filter(c -> !newdesc.getFormat().generatedOnLoadComponents().contains(c)).filter(c -> !c.equals(SSTableFormat.Components.DATA)).forEach(c -> FileUtils.copyWithConfirm(tmpdesc.fileFor((Component)c), newdesc.fileFor((Component)c)));
        FileUtils.copyWithConfirm(tmpdesc.fileFor(SSTableFormat.Components.DATA), newdesc.fileFor(SSTableFormat.Components.DATA));
        components.stream().filter(c -> newdesc.getFormat().generatedOnLoadComponents().contains(c)).forEach(c -> FileUtils.copyWithOutConfirm(tmpdesc.fileFor((Component)c), newdesc.fileFor((Component)c)));
    }

    public static void hardlink(Descriptor tmpdesc, Descriptor newdesc, Set<Component> components) {
        components.stream().filter(c -> !newdesc.getFormat().generatedOnLoadComponents().contains(c)).filter(c -> !c.equals(SSTableFormat.Components.DATA)).forEach(c -> FileUtils.createHardLinkWithConfirm(tmpdesc.fileFor((Component)c), newdesc.fileFor((Component)c)));
        FileUtils.createHardLinkWithConfirm(tmpdesc.fileFor(SSTableFormat.Components.DATA), newdesc.fileFor(SSTableFormat.Components.DATA));
        components.stream().filter(c -> newdesc.getFormat().generatedOnLoadComponents().contains(c)).forEach(c -> FileUtils.createHardLinkWithoutConfirm(tmpdesc.fileFor((Component)c), newdesc.fileFor((Component)c)));
    }

    public abstract DecoratedKey getFirst();

    public abstract DecoratedKey getLast();

    public abstract AbstractBounds<Token> getBounds();

    @VisibleForTesting
    public Set<Component> getComponents() {
        return ImmutableSet.copyOf(this.components);
    }

    public Set<Component> getStreamingComponents() {
        return this.components.stream().filter(c -> c.type.streamable).collect(Collectors.toSet());
    }

    public TableMetadata metadata() {
        return this.metadata.get();
    }

    public IPartitioner getPartitioner() {
        return this.metadata().partitioner;
    }

    public DecoratedKey decorateKey(ByteBuffer key) {
        return this.getPartitioner().decorateKey(key);
    }

    public String getFilename() {
        return this.descriptor.fileFor(SSTableFormat.Components.DATA).absolutePath();
    }

    public String getColumnFamilyName() {
        return this.descriptor.cfname;
    }

    public String getKeyspaceName() {
        return this.descriptor.ksname;
    }

    public List<String> getAllFilePaths() {
        ArrayList<String> ret = new ArrayList<String>(this.components.size());
        for (Component component : this.components) {
            ret.add(this.descriptor.fileFor(component).absolutePath());
        }
        return ret;
    }

    protected final <B extends Builder<?, B>> B unbuildTo(B builder, boolean sharedCopy) {
        return ((Builder)((Builder)((Builder)builder.setTableMetadataRef(this.metadata)).setComponents(this.components)).setChunkCache(this.chunkCache)).setIOOptions(this.ioOptions);
    }

    public static Pair<Descriptor, Component> tryComponentFromFilename(File file) {
        try {
            return Descriptor.fromFileWithComponent(file);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Pair<Descriptor, Component> tryComponentFromFilename(File file, String keyspace, String table) {
        try {
            return Descriptor.fromFileWithComponent(file, keyspace, table);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static Descriptor tryDescriptorFromFile(File file) {
        try {
            return Descriptor.fromFile(file);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String toString() {
        return String.format("%s:%s(path='%s')", this.getClass().getSimpleName(), this.descriptor.version.format.name(), this.getFilename());
    }

    public static void validateRepairedMetadata(long repairedAt, TimeUUID pendingRepair, boolean isTransient) {
        Preconditions.checkArgument(pendingRepair == ActiveRepairService.NO_PENDING_REPAIR || repairedAt == 0L, "pendingRepair cannot be set on a repaired sstable");
        Preconditions.checkArgument(!isTransient || pendingRepair != ActiveRepairService.NO_PENDING_REPAIR, "isTransient can only be true for sstables pending repair");
    }

    public synchronized void addComponents(Collection<Component> newComponents) {
        Collection<Component> componentsToAdd = Collections2.filter(newComponents, Predicates.not(Predicates.in(this.components)));
        TOCComponent.appendTOC(this.descriptor, componentsToAdd);
        this.components.addAll(componentsToAdd);
    }

    public synchronized void registerComponents(Collection<Component> newComponents, Tracker tracker) {
        HashSet<Component> componentsToAdd = new HashSet<Component>(Collections2.filter(newComponents, x -> !this.components.contains(x)));
        TOCComponent.appendTOC(this.descriptor, componentsToAdd);
        this.components.addAll(componentsToAdd);
        for (Component component : componentsToAdd) {
            File file = this.descriptor.fileFor(component);
            if (!file.exists()) continue;
            tracker.updateLiveDiskSpaceUsed(file.length());
        }
    }

    public synchronized void unregisterComponents(Collection<Component> removeComponents, Tracker tracker) {
        HashSet<Component> componentsToRemove = new HashSet<Component>(Collections2.filter(removeComponents, this.components::contains));
        this.components.removeAll(componentsToRemove);
        TOCComponent.rewriteTOC(this.descriptor, this.components);
        for (Component component : componentsToRemove) {
            File file = this.descriptor.fileFor(component);
            if (!file.exists()) continue;
            tracker.updateLiveDiskSpaceUsed(-file.length());
        }
    }

    public static class Builder<S extends SSTable, B extends Builder<S, B>> {
        public final Descriptor descriptor;
        private Set<Component> components;
        private TableMetadataRef tableMetadataRef;
        private ChunkCache chunkCache = ChunkCache.instance;
        private IOOptions ioOptions = IOOptions.fromDatabaseDescriptor();

        public Builder(Descriptor descriptor) {
            Preconditions.checkNotNull(descriptor);
            this.descriptor = descriptor;
        }

        public B setComponents(Collection<Component> components) {
            if (components != null) {
                components.forEach(c -> Preconditions.checkState(c.isValidFor(this.descriptor), "Invalid component type for sstable format " + this.descriptor.version.format.name()));
                this.components = ImmutableSet.copyOf(components);
            } else {
                this.components = null;
            }
            return (B)this;
        }

        public B addComponents(Collection<Component> components) {
            if (components == null || components.isEmpty()) {
                return (B)this;
            }
            if (this.components == null) {
                return this.setComponents(components);
            }
            return this.setComponents(Sets.union(this.components, ImmutableSet.copyOf(components)));
        }

        public B setTableMetadataRef(TableMetadataRef ref) {
            this.tableMetadataRef = ref;
            return (B)this;
        }

        public B setChunkCache(ChunkCache chunkCache) {
            this.chunkCache = chunkCache;
            return (B)this;
        }

        public B setIOOptions(IOOptions ioOptions) {
            this.ioOptions = ioOptions;
            return (B)this;
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        public Set<Component> getComponents() {
            return this.components;
        }

        public TableMetadataRef getTableMetadataRef() {
            return this.tableMetadataRef;
        }

        public ChunkCache getChunkCache() {
            return this.chunkCache;
        }

        public IOOptions getIOOptions() {
            return this.ioOptions;
        }
    }

    public static interface Owner {
        public Double getCrcCheckChance();

        public OpOrder.Barrier newReadOrderingBarrier();

        public TableMetrics getMetrics();
    }
}

